/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.config.PresetService;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;

public final class Road {
    private final ServerLevel level;
    private final Records.StructureConnection connection;
    private final RoadFeatureConfig config;

    public Road(ServerLevel level, Records.StructureConnection connection, RoadFeatureConfig config) {
        this.level = level;
        this.connection = connection;
        this.config = config;
    }

    public void generateRoad(int maxSteps) {
        RandomSource random = RandomSource.m_216327_();
        int width = ConfigService.get().roadWidth() > 0 ? ConfigService.get().roadWidth() : Road.getRandomWidth(random, this.config);
        ModConfig cfg = ConfigService.get();
        boolean allowA = cfg.allowArtificial();
        boolean allowN = cfg.allowNatural();
        if (!allowA && !allowN) {
            return;
        }
        int type = allowA && allowN ? (random.m_188499_() ? 0 : 1) : (allowA ? 0 : 1);
        List<BlockState> materials = type == 0 ? PresetService.chooseMaterialsForArtificial(random, cfg) : List.of(Blocks.f_152481_.m_49966_(), Blocks.f_49994_.m_49966_());
        BlockPos start = this.connection.from();
        BlockPos end = this.connection.to();
        List<Records.RoadSegmentPlacement> segments = RoadPathCalculator.calculateAStarRoadPath(start, end, width, this.level, maxSteps);
        if (segments == null || segments.size() < 5) {
            return;
        }
        List<Records.RoadSpan> spans = RoadPathCalculator.extractSpans(segments, this.level);
        List<Integer> targetY = Road.computeTargetY(this.level, segments, spans);
        Records.RoadData rd = new Records.RoadData(width, type, materials, segments, spans, targetY);
        RoadShardStorage.addRoad(this.level, rd);
    }

    private static int getRandomWidth(RandomSource rnd, RoadFeatureConfig cfg) {
        return 3;
    }

    private static List<Integer> computeTargetY(ServerLevel level, List<Records.RoadSegmentPlacement> segments, List<Records.RoadSpan> spans) {
        int n = segments.size();
        ArrayList<BlockPos> centers = new ArrayList<BlockPos>(n);
        for (Records.RoadSegmentPlacement s : segments) {
            centers.add(s.middlePos());
        }
        boolean[] isBridge = new boolean[n];
        if (spans != null && !spans.isEmpty()) {
            HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
            for (int i = 0; i < centers.size(); ++i) {
                indexMap.put(((BlockPos)centers.get(i)).m_121878_(), i);
            }
            for (Records.RoadSpan sp : spans) {
                if (sp.type() != Records.SpanType.BRIDGE) continue;
                Integer si = (Integer)indexMap.get(sp.start().m_121878_());
                Integer ei = (Integer)indexMap.get(sp.end().m_121878_());
                if (si == null || ei == null) continue;
                int a = Math.max(0, Math.min(si, ei));
                int b = Math.min(n - 1, Math.max(si, ei));
                for (int k = a; k <= b; ++k) {
                    isBridge[k] = true;
                }
            }
        }
        int avg = Math.max(0, ConfigService.get().averagingRadius());
        int[] base = new int[n];
        for (int i = 0; i < n; ++i) {
            int sum = 0;
            int cnt = 0;
            int lo = Math.max(0, i - avg);
            int hi = Math.min(n - 1, i + avg);
            for (int j = lo; j <= hi; ++j) {
                BlockPos sp = (BlockPos)centers.get(j);
                int yTop = RoadPathCalculator.heightSampler(sp.m_123341_(), sp.m_123343_(), level);
                sum += yTop;
                ++cnt;
            }
            base[i] = cnt > 0 ? (int)Math.round((double)sum / (double)cnt) : ((BlockPos)centers.get(i)).m_123342_();
        }
        int[] smoothed = (int[])base.clone();
        int i = 0;
        while (i < n) {
            int y;
            int ii;
            while (i < n && isBridge[i]) {
                ++i;
            }
            int s = i;
            while (i < n && !isBridge[i]) {
                ++i;
            }
            int e = i - 1;
            if (s > e) continue;
            int step = Math.max(0, Math.min(8, ConfigService.get().maxSlopeStepPerTwoSegments()));
            for (ii = s + 2; ii <= e; ++ii) {
                y = smoothed[ii];
                int py = smoothed[ii - 2];
                if (y > py + step) {
                    y = py + step;
                }
                if (y < py - step) {
                    y = py - step;
                }
                smoothed[ii] = y;
            }
            for (ii = e - 2; ii >= s; --ii) {
                y = smoothed[ii];
                int ny = smoothed[ii + 2];
                if (y > ny + step) {
                    y = ny + step;
                }
                if (y < ny - step) {
                    y = ny - step;
                }
                smoothed[ii] = y;
            }
        }
        ArrayList<Integer> out = new ArrayList<Integer>(n);
        for (int v : smoothed) {
            out.add(v);
        }
        return out;
    }
}

