/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence.forge;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public class ForgeWorldDataProvider
extends WorldDataProvider {
    private static final String DATA_NAME = "roadweaver_world_data";

    private Data getOrCreate(ServerLevel level) {
        return (Data)level.m_8895_().m_164861_(Data::load, Data::new, DATA_NAME);
    }

    @Override
    public Records.StructureLocationData getStructureLocations(ServerLevel level) {
        return this.getOrCreate(level).getStructureLocations();
    }

    @Override
    public void setStructureLocations(ServerLevel level, Records.StructureLocationData data) {
        this.getOrCreate(level).setStructureLocations(data);
    }

    @Override
    public List<Records.StructureConnection> getStructureConnections(ServerLevel level) {
        return this.getOrCreate(level).getConnections();
    }

    @Override
    public void setStructureConnections(ServerLevel level, List<Records.StructureConnection> connections) {
        this.getOrCreate(level).setConnections(connections);
    }

    @Override
    public Set<Long> getPlannedTileKeys(ServerLevel level) {
        return this.getOrCreate(level).getPlannedTileKeys();
    }

    @Override
    public void setPlannedTileKeys(ServerLevel level, Set<Long> keys) {
        this.getOrCreate(level).setPlannedTileKeys(keys);
    }

    @Override
    public Map<Long, Long> getPlannedTileCenters(ServerLevel level) {
        return this.getOrCreate(level).getPlannedTileCenters();
    }

    @Override
    public void setPlannedTileCenters(ServerLevel level, Map<Long, Long> centers) {
        this.getOrCreate(level).setPlannedTileCenters(centers);
    }

    public static class Data
    extends SavedData {
        private Records.StructureLocationData structureLocations = new Records.StructureLocationData(new ArrayList<BlockPos>());
        private List<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>();
        private Set<Long> plannedTileKeys = new HashSet<Long>();
        private Map<Long, Long> plannedTileCenters = new HashMap<Long, Long>();
        private static final String KEY_LOCATIONS = "structure_locations";
        private static final String KEY_CONNECTIONS = "connections";
        private static final String KEY_PLANNED_TILES = "planned_tiles";
        private static final String KEY_PLANNED_TILE_CENTERS = "planned_tile_centers";

        public static Data load(CompoundTag tag) {
            Tag t;
            DataResult res;
            Data data = new Data();
            NbtOps ops = NbtOps.f_128958_;
            if (tag.m_128441_(KEY_LOCATIONS)) {
                Tag locTag = tag.m_128423_(KEY_LOCATIONS);
                res = Records.StructureLocationData.CODEC.parse(new Dynamic((DynamicOps)ops, (Object)locTag));
                res.result().ifPresent(val -> {
                    data.structureLocations = val;
                });
            }
            if (tag.m_128441_(KEY_CONNECTIONS)) {
                Tag conTag = tag.m_128423_(KEY_CONNECTIONS);
                res = Codec.list(Records.StructureConnection.CODEC).parse(new Dynamic((DynamicOps)ops, (Object)conTag));
                res.result().ifPresent(val -> {
                    data.connections = val;
                });
            }
            if (tag.m_128441_(KEY_PLANNED_TILES)) {
                t = tag.m_128423_(KEY_PLANNED_TILES);
                res = Codec.list((Codec)Codec.LONG).parse(new Dynamic((DynamicOps)ops, (Object)t));
                res.result().ifPresent(list -> {
                    data.plannedTileKeys = new HashSet<Long>((Collection<Long>)list);
                });
            }
            if (tag.m_128441_(KEY_PLANNED_TILE_CENTERS)) {
                t = tag.m_128423_(KEY_PLANNED_TILE_CENTERS);
                res = Codec.unboundedMap((Codec)Codec.LONG, (Codec)Codec.LONG).parse(new Dynamic((DynamicOps)ops, (Object)t));
                res.result().ifPresent(map -> {
                    data.plannedTileCenters = map;
                });
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            NbtOps ops = NbtOps.f_128958_;
            Records.StructureLocationData.CODEC.encodeStart((DynamicOps)ops, (Object)this.structureLocations).result().ifPresent(nbt -> tag.m_128365_(KEY_LOCATIONS, nbt));
            Codec.list(Records.StructureConnection.CODEC).encodeStart((DynamicOps)ops, this.connections).result().ifPresent(nbt -> tag.m_128365_(KEY_CONNECTIONS, nbt));
            Codec.list((Codec)Codec.LONG).encodeStart((DynamicOps)ops, new ArrayList<Long>(this.plannedTileKeys)).result().ifPresent(nbt -> tag.m_128365_(KEY_PLANNED_TILES, nbt));
            Codec.unboundedMap((Codec)Codec.LONG, (Codec)Codec.LONG).encodeStart((DynamicOps)ops, this.plannedTileCenters).result().ifPresent(nbt -> tag.m_128365_(KEY_PLANNED_TILE_CENTERS, nbt));
            return tag;
        }

        public Records.StructureLocationData getStructureLocations() {
            return this.structureLocations;
        }

        public void setStructureLocations(Records.StructureLocationData data) {
            this.structureLocations = Objects.requireNonNullElseGet(data, () -> new Records.StructureLocationData(new ArrayList<BlockPos>()));
            this.m_77762_();
        }

        public List<Records.StructureConnection> getConnections() {
            return this.connections;
        }

        public void setConnections(List<Records.StructureConnection> connections) {
            this.connections = Objects.requireNonNullElseGet(connections, ArrayList::new);
            this.m_77762_();
        }

        public Set<Long> getPlannedTileKeys() {
            return this.plannedTileKeys;
        }

        public void setPlannedTileKeys(Set<Long> keys) {
            this.plannedTileKeys = Objects.requireNonNullElseGet(keys, HashSet::new);
            this.m_77762_();
        }

        public Map<Long, Long> getPlannedTileCenters() {
            return this.plannedTileCenters;
        }

        public void setPlannedTileCenters(Map<Long, Long> centers) {
            this.plannedTileCenters = Objects.requireNonNullElseGet(centers, HashMap::new);
            this.m_77762_();
        }
    }
}

