/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.achievements;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public final class AchievementService {
    private static final ResourceLocation ADV_FIRST_1 = new ResourceLocation("roadweaver", "road_first_step_1");
    private static final ResourceLocation ADV_FIRST_2 = new ResourceLocation("roadweaver", "road_first_step_2");
    private static final Map<ServerLevel, Set<Long>> ROAD_INDEX = new ConcurrentHashMap<ServerLevel, Set<Long>>();
    private static final Map<ServerLevel, Integer> ROAD_COUNT = new ConcurrentHashMap<ServerLevel, Integer>();

    private AchievementService() {
    }

    public static void tick(ServerLevel level) {
        if (level == null) {
            return;
        }
        AchievementService.ensureIndex(level);
        Set<Long> index = ROAD_INDEX.get(level);
        if (index == null || index.isEmpty()) {
            return;
        }
        for (ServerPlayer sp : level.m_7654_().m_6846_().m_11314_()) {
            if (sp == null || sp.m_284548_() != level) continue;
            BlockPos feet = sp.m_20183_();
            long key = AchievementService.hashXZ(feet.m_123341_(), feet.m_123343_());
            long keyBelow = AchievementService.hashXZ(feet.m_123341_(), feet.m_123343_());
            if (!index.contains(key) && !index.contains(keyBelow)) continue;
            AchievementService.award(sp, ADV_FIRST_1, "entered_road");
            AchievementService.award(sp, ADV_FIRST_2, "entered_road");
        }
    }

    private static void ensureIndex(ServerLevel level) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.RoadData> list = provider.getRoadDataList(level);
        int size = list == null ? 0 : list.size();
        Integer prev = ROAD_COUNT.get(level);
        if (prev != null && prev == size && ROAD_INDEX.containsKey(level)) {
            return;
        }
        HashSet<Long> set = new HashSet<Long>();
        if (list != null) {
            for (Records.RoadData rd : list) {
                if (rd == null || rd.roadSegmentList() == null) continue;
                for (Records.RoadSegmentPlacement seg : rd.roadSegmentList()) {
                    if (seg == null || seg.positions() == null) continue;
                    for (BlockPos p : seg.positions()) {
                        set.add(AchievementService.hashXZ(p.m_123341_(), p.m_123343_()));
                    }
                }
            }
        }
        ROAD_INDEX.put(level, set);
        ROAD_COUNT.put(level, size);
    }

    private static void award(ServerPlayer sp, ResourceLocation id, String criterion) {
        Advancement adv = sp.f_8924_.m_129889_().m_136041_(id);
        if (adv == null) {
            return;
        }
        AdvancementProgress progress = sp.m_8960_().m_135996_(adv);
        if (!progress.m_8193_()) {
            sp.m_8960_().m_135988_(adv, criterion);
        }
    }

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }
}

