/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.shiroha233.roadweaver.client.map.GridRenderer;
import net.shiroha233.roadweaver.client.map.RenderUtils;
import net.shiroha233.roadweaver.helpers.Records;

final class MapRenderers {
    private MapRenderers() {
    }

    static void renderGrid(GuiGraphics g, Font font, int mapX, int mapY, int mapW, int mapH, int innerPad, double viewMinX, double viewMaxX, double viewMinZ, double viewMaxZ, int colorGrid, int gridTargetPx, int colorText) {
        GridRenderer.render(g, font, mapX, mapY, mapW, mapH, innerPad, viewMinX, viewMaxX, viewMinZ, viewMaxZ, colorGrid, gridTargetPx, colorText);
    }

    static void renderStructures(GuiGraphics g, List<BlockPos> points, IntUnaryOperator toScreenX, IntUnaryOperator toScreenY, BiPredicate<Integer, Integer> isInViewWorld, int size, int color, int left, int top, int right, int bottom) {
        for (BlockPos p : points) {
            int bx = p.m_123341_();
            int bz = p.m_123343_();
            if (!isInViewWorld.test(bx, bz)) continue;
            int x = toScreenX.applyAsInt(bx);
            int y = toScreenY.applyAsInt(bz);
            RenderUtils.drawPoint(g, x, y, size, color, left, top, right, bottom);
        }
    }

    static void renderConnections(GuiGraphics g, List<Records.StructureConnection> connections, SegmentInView segmentInView, IntUnaryOperator toScreenX, IntUnaryOperator toScreenY, int thickness, int colorPlanned, int colorGenerating, int colorCompleted, int colorFailed, int left, int top, int right, int bottom) {
        for (Records.StructureConnection c : connections) {
            int tz;
            int tx;
            int fz;
            int fx = c.from().m_123341_();
            if (!segmentInView.test(fx, fz = c.from().m_123343_(), tx = c.to().m_123341_(), tz = c.to().m_123343_())) continue;
            int x1 = toScreenX.applyAsInt(fx);
            int y1 = toScreenY.applyAsInt(fz);
            int x2 = toScreenX.applyAsInt(tx);
            int y2 = toScreenY.applyAsInt(tz);
            switch (c.status()) {
                case PLANNED: {
                    RenderUtils.drawThickLine(g, x1, y1, x2, y2, colorPlanned, thickness, left, top, right, bottom);
                    break;
                }
                case GENERATING: {
                    RenderUtils.drawThickDashedLine(g, x1, y1, x2, y2, colorGenerating, thickness, 8, 6, left, top, right, bottom);
                    break;
                }
                case COMPLETED: {
                    RenderUtils.drawThickLine(g, x1, y1, x2, y2, colorCompleted, thickness, left, top, right, bottom);
                    break;
                }
                case FAILED: {
                    RenderUtils.drawThickLine(g, x1, y1, x2, y2, colorFailed, thickness, left, top, right, bottom);
                }
            }
        }
    }

    static void renderRoadPolylines(GuiGraphics g, List<List<BlockPos>> polylines, SegmentInView segmentInView, IntUnaryOperator toScreenX, IntUnaryOperator toScreenY, int thickness, int color, int left, int top, int right, int bottom, int lodStepBlocks) {
        for (List<BlockPos> pl : polylines) {
            int z2w;
            int x2w;
            int z1w;
            int x1w;
            if (pl == null || pl.size() < 2) continue;
            BlockPos keep = pl.get(0);
            for (int i = 1; i < pl.size(); ++i) {
                int z2w2;
                int x2w2;
                int z1w2;
                int adz;
                BlockPos curr = pl.get(i);
                int dx = curr.m_123341_() - keep.m_123341_();
                int dz = curr.m_123343_() - keep.m_123343_();
                int adx = Math.abs(dx);
                int manhattan = adx + (adz = Math.abs(dz));
                if (manhattan < lodStepBlocks) continue;
                int x1w2 = keep.m_123341_();
                if (segmentInView.test(x1w2, z1w2 = keep.m_123343_(), x2w2 = curr.m_123341_(), z2w2 = curr.m_123343_())) {
                    int x1 = toScreenX.applyAsInt(x1w2);
                    int y1 = toScreenY.applyAsInt(z1w2);
                    int x2 = toScreenX.applyAsInt(x2w2);
                    int y2 = toScreenY.applyAsInt(z2w2);
                    RenderUtils.drawThickLine(g, x1, y1, x2, y2, color, thickness, left, top, right, bottom);
                }
                keep = curr;
            }
            BlockPos tail = pl.get(pl.size() - 1);
            if (tail == keep || !segmentInView.test(x1w = keep.m_123341_(), z1w = keep.m_123343_(), x2w = tail.m_123341_(), z2w = tail.m_123343_())) continue;
            int x1 = toScreenX.applyAsInt(x1w);
            int y1 = toScreenY.applyAsInt(z1w);
            int x2 = toScreenX.applyAsInt(x2w);
            int y2 = toScreenY.applyAsInt(z2w);
            RenderUtils.drawThickLine(g, x1, y1, x2, y2, color, thickness, left, top, right, bottom);
        }
    }

    static void renderLegend(GuiGraphics g, Font font, int rightBound, int startY, int gap, int colorText, int colorStruct, int colorPlanned, int colorGenerating, int colorCompleted, int colorFailed, int structuresCount, int plannedCount, int generatingCount, int completedCount, int failedCount) {
        int y = startY;
        MutableComponent l1 = Component.m_237115_((String)"gui.roadweaver.map.legend.structures").m_130946_(": ").m_130946_(Integer.toString(structuresCount));
        int w1 = font.m_92852_((FormattedText)l1);
        int x1 = rightBound - w1;
        int sr = x1 - gap;
        g.m_280509_(sr - 5, y + 1, sr, y + 6, colorStruct);
        g.m_280614_(font, (Component)l1, x1, y, colorText, false);
        MutableComponent l2 = Component.m_237115_((String)"gui.roadweaver.map.legend.planned").m_130946_(": ").m_130946_(Integer.toString(plannedCount));
        int w2 = font.m_92852_((FormattedText)l2);
        int x2 = rightBound - w2;
        sr = x2 - gap;
        g.m_280509_(sr - 28, (y += 16) + 2, sr, y + 7, colorPlanned);
        g.m_280614_(font, (Component)l2, x2, y, colorText, false);
        MutableComponent l3 = Component.m_237115_((String)"gui.roadweaver.map.legend.generating").m_130946_(": ").m_130946_(Integer.toString(generatingCount));
        int w3 = font.m_92852_((FormattedText)l3);
        int x3 = rightBound - w3;
        sr = x3 - gap;
        int cy = (y += 16) + 4;
        RenderUtils.drawThickDashedLine(g, sr - 28, cy, sr, cy, colorGenerating, 5, 8, 6, sr - 28, y + 1, sr, y + 8);
        g.m_280614_(font, (Component)l3, x3, y, colorText, false);
        MutableComponent l4 = Component.m_237115_((String)"gui.roadweaver.map.legend.completed").m_130946_(": ").m_130946_(Integer.toString(completedCount));
        int w4 = font.m_92852_((FormattedText)l4);
        int x4 = rightBound - w4;
        sr = x4 - gap;
        g.m_280509_(sr - 28, (y += 16) + 2, sr, y + 7, colorCompleted);
        g.m_280614_(font, (Component)l4, x4, y, colorText, false);
        MutableComponent l5 = Component.m_237115_((String)"gui.roadweaver.map.legend.failed").m_130946_(": ").m_130946_(Integer.toString(failedCount));
        int w5 = font.m_92852_((FormattedText)l5);
        int x5 = rightBound - w5;
        sr = x5 - gap;
        g.m_280509_(sr - 28, (y += 16) + 2, sr, y + 7, colorFailed);
        g.m_280614_(font, (Component)l5, x5, y, colorText, false);
    }

    static void drawPlayerArrow(GuiGraphics g, int sx, int sy, float yawDeg, int tipLen, int baseLen, int baseHalfWidth, int color, int left, int top, int right, int bottom, double pxPerBlockX, double pxPerBlockZ) {
        double vz;
        double dirY;
        double rx = Math.toRadians(yawDeg);
        double vx = -Math.sin(rx);
        double dirX = vx * pxPerBlockX;
        double mag = Math.hypot(dirX, dirY = (vz = Math.cos(rx)) * pxPerBlockZ);
        if (mag < 1.0E-6) {
            dirX = 1.0;
            dirY = 0.0;
            mag = 1.0;
        }
        double px = (double)sx + (dirX /= mag) * (double)tipLen;
        double py = (double)sy + (dirY /= mag) * (double)tipLen;
        double bx = (double)sx - dirX * (double)baseLen;
        double by = (double)sy - dirY * (double)baseLen;
        double perpX = -dirY;
        double perpY = dirX;
        double bx1 = bx + perpX * (double)baseHalfWidth;
        double by1 = by + perpY * (double)baseHalfWidth;
        double bx2 = bx - perpX * (double)baseHalfWidth;
        double by2 = by - perpY * (double)baseHalfWidth;
        int ipx = (int)Math.round(px);
        int ipy = (int)Math.round(py);
        int ibx1 = (int)Math.round(bx1);
        int iby1 = (int)Math.round(by1);
        int ibx2 = (int)Math.round(bx2);
        int iby2 = (int)Math.round(by2);
        int outline = -1;
        RenderUtils.fillTriangle(g, ipx - 1, ipy, ibx1 - 1, iby1, ibx2 - 1, iby2, outline, left, top, right, bottom);
        RenderUtils.fillTriangle(g, ipx + 1, ipy, ibx1 + 1, iby1, ibx2 + 1, iby2, outline, left, top, right, bottom);
        RenderUtils.fillTriangle(g, ipx, ipy - 1, ibx1, iby1 - 1, ibx2, iby2 - 1, outline, left, top, right, bottom);
        RenderUtils.fillTriangle(g, ipx, ipy + 1, ibx1, iby1 + 1, ibx2, iby2 + 1, outline, left, top, right, bottom);
        RenderUtils.fillTriangle(g, ipx, ipy, ibx1, iby1, ibx2, iby2, color, left, top, right, bottom);
    }

    static interface SegmentInView {
        public boolean test(int var1, int var2, int var3, int var4);
    }
}

