/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.shiroha233.roadweaver.helpers.Records;

public class MapSnapshot {
    private final List<BlockPos> structures;
    private final List<Records.StructureConnection> connections;
    private final Map<BlockPos, String> structureNames;
    private final List<List<BlockPos>> roadPolylines;
    private final int minX;
    private final int minZ;
    private final int maxX;
    private final int maxZ;

    public MapSnapshot(List<BlockPos> structures, List<Records.StructureConnection> connections, List<Records.StructureInfo> structureInfos, List<List<BlockPos>> roadPolylines) {
        int n;
        int n2;
        int n3;
        this.structures = Collections.unmodifiableList(new ArrayList<BlockPos>(structures != null ? structures : List.of()));
        this.connections = Collections.unmodifiableList(new ArrayList<Records.StructureConnection>(connections != null ? connections : List.of()));
        HashMap<BlockPos, String> nm = new HashMap<BlockPos, String>();
        if (structureInfos != null) {
            for (Records.StructureInfo structureInfo : structureInfos) {
                nm.put(structureInfo.pos(), structureInfo.structureId());
            }
        }
        this.structureNames = Collections.unmodifiableMap(nm);
        ArrayList<List<BlockPos>> rp = new ArrayList<List<BlockPos>>();
        if (roadPolylines != null) {
            for (List<BlockPos> list : roadPolylines) {
                rp.add(Collections.unmodifiableList(new ArrayList<BlockPos>(list)));
            }
        }
        this.roadPolylines = Collections.unmodifiableList(rp);
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos blockPos : this.structures) {
            int n6;
            int n7;
            if (blockPos.m_123341_() < n7) {
                n7 = blockPos.m_123341_();
            }
            if (blockPos.m_123343_() < n6) {
                n6 = blockPos.m_123343_();
            }
            if (blockPos.m_123341_() > maxX) {
                maxX = blockPos.m_123341_();
            }
            if (blockPos.m_123343_() <= maxZ) continue;
            maxZ = blockPos.m_123343_();
        }
        for (Records.StructureConnection structureConnection : this.connections) {
            int n8;
            int n9;
            BlockPos a = structureConnection.from();
            BlockPos b = structureConnection.to();
            if (a.m_123341_() < n9) {
                n9 = a.m_123341_();
            }
            if (a.m_123343_() < n8) {
                n8 = a.m_123343_();
            }
            if (a.m_123341_() > maxX) {
                maxX = a.m_123341_();
            }
            if (a.m_123343_() > maxZ) {
                maxZ = a.m_123343_();
            }
            if (b.m_123341_() < n9) {
                n9 = b.m_123341_();
            }
            if (b.m_123343_() < n8) {
                n8 = b.m_123343_();
            }
            if (b.m_123341_() > maxX) {
                maxX = b.m_123341_();
            }
            if (b.m_123343_() <= maxZ) continue;
            maxZ = b.m_123343_();
        }
        for (List list : this.roadPolylines) {
            for (BlockPos p : list) {
                int n10;
                if (p.m_123341_() < n3) {
                    n3 = p.m_123341_();
                }
                if (p.m_123343_() < n10) {
                    n10 = p.m_123343_();
                }
                if (p.m_123341_() > maxX) {
                    maxX = p.m_123341_();
                }
                if (p.m_123343_() <= maxZ) continue;
                maxZ = p.m_123343_();
            }
        }
        if (n3 == Integer.MAX_VALUE) {
            n2 = 0;
            n = 0;
            maxZ = 1;
            maxX = 1;
        }
        this.minX = n;
        this.minZ = n2;
        this.maxX = maxX;
        this.maxZ = maxZ;
    }

    public List<BlockPos> structures() {
        return this.structures;
    }

    public List<Records.StructureConnection> connections() {
        return this.connections;
    }

    public String structureName(BlockPos pos) {
        return this.structureNames.get(pos);
    }

    public List<List<BlockPos>> roadPolylines() {
        return this.roadPolylines;
    }

    public int minX() {
        return this.minX;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxX() {
        return this.maxX;
    }

    public int maxZ() {
        return this.maxZ;
    }

    public int structuresCount() {
        return this.structures.size();
    }

    public int plannedCount() {
        return (int)this.connections.stream().filter(c -> c.status() == Records.ConnectionStatus.PLANNED).count();
    }

    public int generatingCount() {
        return (int)this.connections.stream().filter(c -> c.status() == Records.ConnectionStatus.GENERATING).count();
    }

    public int completedCount() {
        return (int)this.connections.stream().filter(c -> c.status() == Records.ConnectionStatus.COMPLETED).count();
    }

    public int failedCount() {
        return (int)this.connections.stream().filter(c -> c.status() == Records.ConnectionStatus.FAILED).count();
    }

    public static MapSnapshot empty() {
        return new MapSnapshot(List.of(), List.of(), List.of(), List.of());
    }
}

