/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.system.RoadDecorationSystem;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public class RoadFeature
extends Feature<RoadFeatureConfig> {
    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RoadFeatureConfig> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        ServerLevel lvl = world.m_6018_();
        if (!(lvl instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = lvl;
        List<Records.RoadData> roadDataList = WorldDataProvider.getInstance().getRoadDataList(server);
        if (roadDataList == null || roadDataList.isEmpty()) {
            return false;
        }
        ChunkPos currentChunk = new ChunkPos(ctx.m_159777_());
        HashSet<BlockPos> processedMiddle = new HashSet<BlockPos>();
        RandomSource random = ctx.m_225041_();
        ModConfig cfg = ConfigService.get();
        int averagingRadius = Math.max(0, cfg.averagingRadius());
        HashSet<Decoration> decorations = new HashSet<Decoration>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            int roadWidth = Math.max(1, data.width());
            List<BlockState> materials = data.materials();
            List<Records.RoadSegmentPlacement> segments = data.roadSegmentList();
            if (segments == null || segments.size() < 5) continue;
            List<BlockPos> middlePositions = segments.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            int segmentIndex = 0;
            for (int i = 2; i < segments.size() - 2; ++i) {
                ChunkPos middleChunk;
                BlockPos middle = middlePositions.get(i);
                if (!processedMiddle.add(middle) || ++segmentIndex < 60 || segmentIndex > segments.size() - 60 || !(middleChunk = new ChunkPos(middle)).equals((Object)currentChunk)) continue;
                BlockPos prev = middlePositions.get(i - 2);
                BlockPos next = middlePositions.get(i + 2);
                ArrayList<Integer> heights = new ArrayList<Integer>();
                for (int j = i - averagingRadius; j <= i + averagingRadius; ++j) {
                    if (j < 0 || j >= middlePositions.size()) continue;
                    BlockPos sample = middlePositions.get(j);
                    int yTop = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, sample.m_123341_(), sample.m_123343_());
                    heights.add(yTop);
                }
                int averageY = heights.isEmpty() ? middle.m_123342_() : (int)Math.round(heights.stream().mapToInt(Integer::intValue).average().orElse(middle.m_123342_()));
                int topYCenter = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, middle.m_123341_(), middle.m_123343_());
                BlockPos averaged = new BlockPos(middle.m_123341_(), topYCenter, middle.m_123343_());
                Records.RoadSegmentPlacement seg = segments.get(i);
                for (BlockPos widthBlock : seg.positions()) {
                    BlockPos pos = new BlockPos(widthBlock.m_123341_(), averageY, widthBlock.m_123343_());
                    RoadFeature.placeOnSurface(world, pos, materials, roadType, random, cfg);
                }
                RoadFeature.addDecoration(world, decorations, averaged, segmentIndex, next, prev, middlePositions, roadType, roadWidth, random, cfg);
            }
        }
        RoadDecorationSystem.finalizeDecorations(decorations);
        return true;
    }

    private static void placeOnSurface(WorldGenLevel world, BlockPos placePos, List<BlockState> material, int roadType, RandomSource random, ModConfig cfg) {
        RoadDecorationSystem.placeOnSurface(world, placePos, material, roadType, random, cfg);
    }

    private static void addDecoration(WorldGenLevel world, Set<Decoration> out, BlockPos placePos, int segmentIndex, BlockPos nextPos, BlockPos prevPos, List<BlockPos> middlePositions, int roadType, int roadWidth, RandomSource random, ModConfig cfg) {
        RoadDecorationSystem.addDecoration(world, out, placePos, segmentIndex, nextPos, prevPos, middlePositions, roadType, roadWidth, random, cfg);
    }
}

