/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration;

import java.util.Iterator;
import java.util.Set;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.DistanceSignDecoration;
import net.shiroha233.roadweaver.features.decoration.FenceWaypointDecoration;
import net.shiroha233.roadweaver.features.decoration.LamppostDecoration;
import net.shiroha233.roadweaver.features.decoration.util.WoodSelector;

public final class RoadStructures {
    private RoadStructures() {
    }

    public static void tryPlaceDecorations(Set<Decoration> positions) {
        if (positions.isEmpty()) {
            return;
        }
        Iterator<Decoration> it = positions.iterator();
        while (it.hasNext()) {
            Decoration dec = it.next();
            if (dec == null) continue;
            if (dec instanceof LamppostDecoration) {
                LamppostDecoration lamp = (LamppostDecoration)dec;
                lamp.setWoodType(WoodSelector.forBiome(lamp.getWorld(), lamp.getPos()));
                lamp.place();
            } else if (dec instanceof DistanceSignDecoration) {
                DistanceSignDecoration sign = (DistanceSignDecoration)dec;
                sign.setWoodType(WoodSelector.forBiome(sign.getWorld(), sign.getPos()));
                sign.place();
            } else if (dec instanceof FenceWaypointDecoration) {
                FenceWaypointDecoration wp = (FenceWaypointDecoration)dec;
                wp.setWoodType(WoodSelector.forBiome(wp.getWorld(), wp.getPos()));
                wp.place();
            }
            it.remove();
        }
    }
}

