/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.config.PresetService;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.DistanceSignDecoration;
import net.shiroha233.roadweaver.features.decoration.FenceWaypointDecoration;
import net.shiroha233.roadweaver.features.decoration.LamppostDecoration;
import net.shiroha233.roadweaver.features.decoration.RoadFeatureCompat;
import net.shiroha233.roadweaver.features.decoration.RoadStructures;

public final class RoadDecorationSystem {
    private static final int SIGN_INDEX_OFFSET = 65;
    private static final int SIDE_OFFSET = 2;

    private RoadDecorationSystem() {
    }

    public static List<BlockState> selectMaterials(RandomSource rnd, RoadFeatureConfig cfg) {
        return RoadDecorationSystem.selectMaterialsFromPresets(rnd);
    }

    public static List<BlockState> selectMaterialsFromPresets(RandomSource rnd) {
        List<List<String>> combos = PresetService.getMaterialCombos();
        if (combos == null || combos.isEmpty()) {
            return List.of(Blocks.f_50222_.m_49966_(), Blocks.f_50387_.m_49966_());
        }
        List<String> chosen = combos.get(rnd.m_188503_(combos.size()));
        List<BlockState> parsed = RoadDecorationSystem.parseMaterials(chosen);
        if (parsed.isEmpty()) {
            return List.of(Blocks.f_50222_.m_49966_());
        }
        return parsed;
    }

    private static List<BlockState> parseMaterials(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return List.of();
        }
        ArrayList<BlockState> out = new ArrayList<BlockState>(ids.size());
        for (String s : ids) {
            try {
                ResourceLocation rl = new ResourceLocation(s);
                Block b = (Block)BuiltInRegistries.f_256975_.m_7745_(rl);
                if (b == null || b == Blocks.f_50016_) continue;
                out.add(b.m_49966_());
            }
            catch (Throwable throwable) {}
        }
        return out;
    }

    public static void placeOnSurface(WorldGenLevel world, BlockPos placePos, List<BlockState> material, int roadType, RandomSource random, ModConfig cfg) {
        double naturalBlockChance = 0.5;
        BlockPos surfacePos = placePos;
        if (roadType == 1 || Math.max(0, cfg.averagingRadius()) == 0) {
            int topY = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, placePos.m_123341_(), placePos.m_123343_());
            surfacePos = new BlockPos(placePos.m_123341_(), topY, placePos.m_123343_());
        }
        int topYForBelow = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, surfacePos.m_123341_(), surfacePos.m_123343_());
        BlockPos belowTop = new BlockPos(surfacePos.m_123341_(), topYForBelow - 1, surfacePos.m_123343_());
        BlockState blockStateAtPos = world.m_8055_(belowTop);
        if (roadType == 0 || random.m_188500_() < naturalBlockChance) {
            RoadDecorationSystem.placeRoadBlock(world, blockStateAtPos, surfacePos, material, random, cfg);
        }
    }

    public static void placeRoadBlock(WorldGenLevel world, BlockState blockBelow, BlockPos surfacePos, List<BlockState> materials, RandomSource random, ModConfig cfg) {
        BlockPos up;
        BlockState blockStateUp;
        if (!RoadDecorationSystem.placeAllowedCheck(blockBelow.m_60734_())) {
            return;
        }
        BlockState chosen = materials.get(random.m_188503_(materials.size()));
        int MAX_CAUSEWAY_DEPTH = 12;
        BlockPos below1 = surfacePos.m_7495_();
        BlockPos below2 = surfacePos.m_6625_(2);
        boolean sturdy1 = world.m_8055_(below1).m_60783_((BlockGetter)world, below1, Direction.UP);
        boolean sturdy2 = world.m_8055_(below2).m_60783_((BlockGetter)world, below2, Direction.UP);
        if (!sturdy1 && !sturdy2) {
            BlockPos fillStart;
            BlockPos cursor = below2;
            BlockPos base = null;
            for (int depth = 0; cursor.m_123342_() > world.m_141937_() && depth < 12; ++depth) {
                if (world.m_8055_(cursor).m_60783_((BlockGetter)world, cursor, Direction.UP)) {
                    base = cursor;
                    break;
                }
                cursor = cursor.m_7495_();
            }
            BlockPos blockPos = fillStart = base != null ? base.m_7494_() : below1.m_6625_(Math.min(11, Math.max(0, below1.m_123342_() - world.m_141937_())));
            if (fillStart.m_123342_() < world.m_141937_()) {
                fillStart = new BlockPos(fillStart.m_123341_(), world.m_141937_(), fillStart.m_123343_());
            }
            BlockPos pos = fillStart;
            while (pos.m_123342_() <= below1.m_123342_()) {
                world.m_7731_(pos, chosen, 3);
                pos = pos.m_7494_();
            }
        } else {
            world.m_7731_(below1, chosen, 3);
        }
        for (int i = 0; !(i >= 3 || (blockStateUp = world.m_8055_(up = surfacePos.m_6630_(i))).m_60795_() || blockStateUp.m_204336_(BlockTags.f_13106_) || blockStateUp.m_204336_(BlockTags.f_13039_)); ++i) {
            world.m_7731_(up, Blocks.f_50016_.m_49966_(), 3);
        }
        BlockPos belowPos1 = surfacePos.m_6625_(2);
        BlockState belowState1 = world.m_8055_(belowPos1);
        if (belowState1.m_60713_(Blocks.f_50440_)) {
            world.m_7731_(belowPos1, Blocks.f_50493_.m_49966_(), 3);
        }
    }

    public static void addDecoration(WorldGenLevel world, Set<Decoration> out, BlockPos placePos, int segmentIndex, BlockPos nextPos, BlockPos prevPos, List<BlockPos> middlePositions, int roadType, int roadWidth, RandomSource random, ModConfig cfg) {
        boolean isStart;
        int dz;
        int dx = nextPos.m_123341_() - prevPos.m_123341_();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = nextPos.m_123343_() - prevPos.m_123343_()) * (double)dz);
        int nx = len != 0.0 ? (int)Math.round((double)dx / len) : 0;
        int nz = len != 0.0 ? (int)Math.round((double)dz / len) : 0;
        Vec3i dir = new Vec3i(nx, 0, nz);
        Vec3i ortho = new Vec3i(-dir.m_123343_(), 0, dir.m_123341_());
        int halfWidth = Math.max(1, roadWidth / 2);
        int sideOffset = Math.max(2, halfWidth + 1);
        boolean bl = isStart = segmentIndex == 65;
        if (segmentIndex == 65 || segmentIndex == middlePositions.size() - 65) {
            BlockPos shifted = isStart ? placePos.m_7918_(ortho.m_123341_() * sideOffset, 0, ortho.m_123343_() * sideOffset) : placePos.m_7918_(-ortho.m_123341_() * sideOffset, 0, -ortho.m_123343_() * sideOffset);
            int dist = RoadDecorationSystem.computeApproxDistanceMeters(world, shifted, isStart, middlePositions);
            out.add(new DistanceSignDecoration(shifted, ortho, world, isStart, String.valueOf(dist)));
        } else {
            int interval = Math.max(1, cfg.lampInterval());
            if (segmentIndex % interval == 0) {
                boolean left = random.m_188499_();
                BlockPos shifted = left ? placePos.m_7918_(ortho.m_123341_() * sideOffset, 0, ortho.m_123343_() * sideOffset) : placePos.m_7918_(-ortho.m_123341_() * sideOffset, 0, -ortho.m_123343_() * sideOffset);
                if (Math.abs((shifted = new BlockPos(shifted.m_123341_(), world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, shifted.m_123341_(), shifted.m_123343_()), shifted.m_123343_())).m_123342_() - placePos.m_123342_()) > 1) {
                    return;
                }
                if (roadType == 0) {
                    out.add(new LamppostDecoration(shifted, ortho, world, left));
                } else {
                    out.add(new FenceWaypointDecoration(shifted, world));
                }
            }
        }
    }

    public static void finalizeDecorations(Set<Decoration> decorations) {
        RoadStructures.tryPlaceDecorations(decorations);
    }

    public static int computeApproxDistanceMeters(WorldGenLevel world, BlockPos fromPos, boolean isStart, List<BlockPos> middlePositions) {
        BlockPos target = isStart ? middlePositions.get(middlePositions.size() - 1) : middlePositions.get(0);
        long dx = (long)target.m_123341_() - (long)fromPos.m_123341_();
        long dz = (long)target.m_123343_() - (long)fromPos.m_123343_();
        double d = Math.sqrt((double)dx * (double)dx + (double)dz * (double)dz);
        return (int)Math.round(d);
    }

    private static boolean placeAllowedCheck(Block block) {
        return !RoadFeatureCompat.dontPlaceHere(block) && !block.m_49966_().m_204336_(BlockTags.f_13035_) && !block.m_49966_().m_204336_(BlockTags.f_13106_) && !block.m_49966_().m_204336_(BlockTags.f_13050_) && !block.m_49966_().m_204336_(BlockTags.f_13098_) && !block.m_49966_().m_204336_(BlockTags.f_13090_);
    }
}

