/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.features.roadlogic.RoadDirection;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.helpers.Records;

final class BasicAStarPathfinder {
    private static final double ORTHO_STEP_COST = 1.0;
    private static final double DIAG_STEP_COST = 1.0;
    private static final int ELEVATION_WEIGHT = 40;
    private static final int BIOME_BASE_COST = 12;
    private static final int BIOME_WEIGHT = 2;
    private static final int STABILITY_WEIGHT = 40;
    private static final int WATER_DEPTH_WEIGHT = 80;
    private static final int NEAR_WATER_COST = 80;
    private static final double HEURISTIC_WEIGHT = 30.0;
    private static final double HEURISTIC_EPSILON = 0.2;
    private static final double DEVIATION_WEIGHT = 5.0;

    private BasicAStarPathfinder() {
    }

    public static List<Records.RoadSegmentPlacement> calculateLandPath(BlockPos startGround, BlockPos endGround, int width, ServerLevel level, int maxSteps) {
        Node current;
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        HashMap<BlockPos, Node> allNodes = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        HashMap<BlockPos, List<BlockPos>> interpolatedSegments = new HashMap<BlockPos, List<BlockPos>>();
        Node startNode = new Node(startGround, null, 0.0, BasicAStarPathfinder.heuristic(startGround, endGround));
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = BasicAStarPathfinder.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        int stepsBudget = Math.max(1, maxSteps);
        while (!openSet.isEmpty() && stepsBudget-- > 0 && (current = openSet.poll()) != null) {
            if (BasicAStarPathfinder.manhattan2d(current.pos, endGround) < d * 2) {
                return BasicAStarPathfinder.reconstructPath(current, width, interpolatedSegments);
            }
            closed.add(current.pos);
            allNodes.remove(current.pos);
            for (int[] off : neighborOffsets) {
                BlockPos nxz = current.pos.m_7918_(off[0], 0, off[1]);
                int y = RoadPathCalculator.heightSampler(nxz.m_123341_(), nxz.m_123343_(), level);
                BlockPos np = new BlockPos(nxz.m_123341_(), y, nxz.m_123343_());
                if (closed.contains(np)) continue;
                Holder biome = level.m_204166_(np);
                int biomeCost = biome.m_203656_(BiomeTags.f_207605_) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207602_) ? 12 : 0;
                int elevation = Math.abs(y - current.pos.m_123342_());
                int offsetSum = Math.abs(Math.abs(off[0])) + Math.abs(off[1]);
                double stepCost = offsetSum == 2 * d ? 1.0 : 1.0;
                int stabilityCost = RoadPathCalculator.calculateTerrainStability(np, y, level);
                int sea = level.m_5736_();
                boolean waterColumn = RoadPathCalculator.isColumnWater(nxz.m_123341_(), nxz.m_123343_(), level);
                boolean nearWater = RoadPathCalculator.isNearWaterLike(nxz.m_123341_(), nxz.m_123343_(), level);
                int oceanFloor = RoadPathCalculator.oceanFloorSampler(nxz.m_123341_(), nxz.m_123343_(), level);
                int waterDepth = Math.max(0, sea - oceanFloor);
                int waterDepthCost = waterColumn ? waterDepth * 80 : 0;
                int nearWaterCost = nearWater ? 80 : 0;
                double deviation = BasicAStarPathfinder.deviation2d(np, startGround, endGround);
                double deviationCost = deviation * 5.0 / Math.max(1.0, (double)d);
                double tentativeG = current.g + stepCost + (double)(elevation * 40) + (double)(biomeCost * 2) + (double)(stabilityCost * 40) + (double)waterDepthCost + (double)nearWaterCost + deviationCost;
                Node n2 = (Node)allNodes.get(np);
                if (n2 != null && !(tentativeG < n2.g)) continue;
                double h = BasicAStarPathfinder.heuristic(np, endGround);
                double fWeighted = tentativeG + 1.2 * h;
                n2 = new Node(np, current, tentativeG, fWeighted);
                allNodes.put(np, n2);
                openSet.add(n2);
                ArrayList<BlockPos> seg = new ArrayList<BlockPos>();
                for (int i = 1; i < d; ++i) {
                    int ix = current.pos.m_123341_() + off[0] * i / d;
                    int iz = current.pos.m_123343_() + off[1] * i / d;
                    seg.add(new BlockPos(ix, current.pos.m_123342_(), iz));
                }
                interpolatedSegments.put(np, seg);
            }
        }
        return null;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node endNode, int width, Map<BlockPos, List<BlockPos>> interpolatedPathMap) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node cur = endNode;
        while (cur != null) {
            nodes.add(cur);
            cur = cur.parent;
        }
        Collections.reverse(nodes);
        LinkedHashMap<BlockPos, Set<BlockPos>> segments = new LinkedHashMap<BlockPos, Set<BlockPos>>();
        HashSet<BlockPos> widthCache = new HashSet<BlockPos>();
        for (Node n : nodes) {
            BlockPos p = n.pos;
            List interp = interpolatedPathMap.getOrDefault(p, Collections.emptyList());
            RoadDirection dir = RoadDirection.X_AXIS;
            if (!interp.isEmpty()) {
                BlockPos f = (BlockPos)interp.get(0);
                int dx = p.m_123341_() - f.m_123341_();
                int dz = p.m_123343_() - f.m_123343_();
                if (dx < 0 && dz > 0 || dx > 0 && dz < 0) {
                    dir = RoadDirection.DIAGONAL_1;
                } else if (dx < 0 && dz < 0 || dx > 0 && dz > 0) {
                    dir = RoadDirection.DIAGONAL_2;
                } else if (dx == 0 && dz != 0) {
                    dir = RoadDirection.Z_AXIS;
                }
                for (BlockPos ip : interp) {
                    Set<BlockPos> ws = RoadPathCalculator.generateWidth(ip, width / 2, widthCache, dir);
                    segments.put(ip, ws);
                }
            }
            Set<BlockPos> ws = RoadPathCalculator.generateWidth(p, width / 2, widthCache, dir);
            segments.put(p, ws);
        }
        ArrayList<Records.RoadSegmentPlacement> out = new ArrayList<Records.RoadSegmentPlacement>();
        for (Map.Entry e : segments.entrySet()) {
            out.add(new Records.RoadSegmentPlacement((BlockPos)e.getKey(), new ArrayList<BlockPos>((Collection)e.getValue())));
        }
        return out;
    }

    private static int getNeighborDistance() {
        try {
            int v = ConfigService.get().aStarStep();
            if (v < 4) {
                return 16;
            }
            if (v > 128) {
                return 128;
            }
            return v;
        }
        catch (Throwable ignore) {
            return 16;
        }
    }

    private static int manhattan2d(BlockPos a, BlockPos b) {
        return Math.abs(a.m_123341_() - b.m_123341_()) + Math.abs(a.m_123343_() - b.m_123343_());
    }

    private static double heuristic(BlockPos a, BlockPos b) {
        int dx = a.m_123341_() - b.m_123341_();
        int dz = a.m_123343_() - b.m_123343_();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * 30.0;
    }

    private static double deviation2d(BlockPos p, BlockPos a, BlockPos b) {
        double ax = a.m_123341_();
        double az = a.m_123343_();
        double bx = b.m_123341_();
        double bz = b.m_123343_();
        double px = p.m_123341_();
        double pz = p.m_123343_();
        double num = Math.abs((bz - az) * px - (bx - ax) * pz + bx * az - bz * ax);
        double den = Math.hypot(bx - ax, bz - az);
        if (den <= 0.0) {
            return 0.0;
        }
        return num / den;
    }

    private static final class Node {
        final BlockPos pos;
        final Node parent;
        final double g;
        final double f;

        Node(BlockPos pos, Node parent, double g, double f) {
            this.pos = pos;
            this.parent = parent;
            this.g = g;
            this.f = f;
        }
    }
}

