/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.system.RoadDecorationSystem;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public final class Road {
    private final ServerLevel level;
    private final Records.StructureConnection connection;
    private final RoadFeatureConfig config;

    public Road(ServerLevel level, Records.StructureConnection connection, RoadFeatureConfig config) {
        this.level = level;
        this.connection = connection;
        this.config = config;
    }

    public void generateRoad(int maxSteps) {
        BlockPos end;
        RandomSource random = RandomSource.m_216327_();
        int width = ConfigService.get().roadWidth() > 0 ? ConfigService.get().roadWidth() : Road.getRandomWidth(random, this.config);
        ModConfig cfg = ConfigService.get();
        if (!cfg.allowArtificial()) {
            return;
        }
        int type = 0;
        List<BlockState> materials = RoadDecorationSystem.selectMaterials(random, this.config);
        BlockPos start = this.connection.from();
        List<Records.RoadSegmentPlacement> segments = RoadPathCalculator.calculateAStarRoadPath(start, end = this.connection.to(), width, this.level, maxSteps);
        if (segments == null || segments.size() < 5) {
            return;
        }
        List<Records.RoadSpan> spans = RoadPathCalculator.extractSpans(segments, this.level);
        WorldDataProvider provider = WorldDataProvider.getInstance();
        ArrayList<Records.RoadData> list = new ArrayList<Records.RoadData>(provider.getRoadDataList(this.level));
        list.add(new Records.RoadData(width, type, materials, segments, spans));
        provider.setRoadDataList(this.level, list);
    }

    private static int getRandomWidth(RandomSource rnd, RoadFeatureConfig cfg) {
        return 3;
    }
}

