/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.features.roadlogic.BasicAStarPathfinder;
import net.shiroha233.roadweaver.features.roadlogic.RoadDirection;
import net.shiroha233.roadweaver.helpers.Records;

public final class RoadPathCalculator {
    public static final Map<Long, Integer> heightCache = new ConcurrentHashMap<Long, Integer>();
    public static final Map<Long, Boolean> waterCache = new ConcurrentHashMap<Long, Boolean>();
    public static final Map<Long, Integer> oceanFloorCache = new ConcurrentHashMap<Long, Integer>();
    public static final Map<Long, Boolean> nearWaterCache = new ConcurrentHashMap<Long, Boolean>();
    public static final Map<Long, Boolean> columnWaterCache = new ConcurrentHashMap<Long, Boolean>();

    private RoadPathCalculator() {
    }

    static int getNeighborDistance() {
        try {
            int v = ConfigService.get().aStarStep();
            if (v < 4) {
                return 16;
            }
            if (v > 128) {
                return 128;
            }
            return v;
        }
        catch (Throwable ignore) {
            return 16;
        }
    }

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(BlockPos startIn, BlockPos endIn, int width, ServerLevel level, int maxSteps) {
        int dGrid = RoadPathCalculator.getNeighborDistance();
        int sx = RoadPathCalculator.snapToGrid(startIn.m_123341_(), dGrid);
        int sz = RoadPathCalculator.snapToGrid(startIn.m_123343_(), dGrid);
        int ex = RoadPathCalculator.snapToGrid(endIn.m_123341_(), dGrid);
        int ez = RoadPathCalculator.snapToGrid(endIn.m_123343_(), dGrid);
        BlockPos start = new BlockPos(sx, startIn.m_123342_(), sz);
        BlockPos end = new BlockPos(ex, endIn.m_123342_(), ez);
        BlockPos startGround = new BlockPos(start.m_123341_(), RoadPathCalculator.heightSampler(start.m_123341_(), start.m_123343_(), level), start.m_123343_());
        BlockPos endGround = new BlockPos(end.m_123341_(), RoadPathCalculator.heightSampler(end.m_123341_(), end.m_123343_(), level), end.m_123343_());
        List<Records.RoadSegmentPlacement> land = BasicAStarPathfinder.calculateLandPath(startGround, endGround, width, level, maxSteps);
        return land;
    }

    static int calculateTerrainStability(BlockPos pos, int y, ServerLevel level) {
        int cost = 0;
        if (Math.abs(RoadPathCalculator.heightSampler(pos.m_123341_() + 1, pos.m_123343_(), level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(pos.m_123341_() - 1, pos.m_123343_(), level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(pos.m_123341_(), pos.m_123343_() + 1, level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(pos.m_123341_(), pos.m_123343_() - 1, level) - y) > 0) {
            ++cost;
        }
        return cost;
    }

    static int heightSampler(int x, int z, ServerLevel level) {
        long key = RoadPathCalculator.hashXZ(x, z);
        return heightCache.computeIfAbsent(key, k -> {
            RandomState rs = level.m_7726_().m_255415_().m_255046_();
            return level.m_7726_().m_8481_().m_214096_(x, z, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)level, rs);
        });
    }

    static boolean isWaterLike(int x, int z, ServerLevel level) {
        long key = RoadPathCalculator.hashXZ(x, z);
        Boolean v = waterCache.get(key);
        if (v != null) {
            return v;
        }
        Holder biome = level.m_204166_(new BlockPos(x, 0, z));
        boolean res = biome.m_203656_(BiomeTags.f_207605_) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207602_);
        waterCache.put(key, res);
        return res;
    }

    static int oceanFloorSampler(int x, int z, ServerLevel level) {
        long key = RoadPathCalculator.hashXZ(x, z);
        return oceanFloorCache.computeIfAbsent(key, k -> {
            RandomState rs = level.m_7726_().m_255415_().m_255046_();
            return level.m_7726_().m_8481_().m_214096_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)level, rs);
        });
    }

    static boolean isNearWaterLike(int x, int z, ServerLevel level) {
        int[][] neighborOffsets;
        long key = RoadPathCalculator.hashXZ(x, z);
        Boolean cached = nearWaterCache.get(key);
        if (cached != null) {
            return cached;
        }
        int d = RoadPathCalculator.getNeighborDistance();
        for (int[] off : neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}}) {
            int nx = x + off[0];
            int nz = z + off[1];
            if (!RoadPathCalculator.isWaterLike(nx, nz, level)) continue;
            nearWaterCache.put(key, true);
            return true;
        }
        nearWaterCache.put(key, false);
        return false;
    }

    static boolean isColumnWater(int x, int z, ServerLevel level) {
        BlockPos check;
        boolean res;
        long key = RoadPathCalculator.hashXZ(x, z);
        Boolean cached = columnWaterCache.get(key);
        if (cached != null) {
            return cached;
        }
        int ws = RoadPathCalculator.heightSampler(x, z, level);
        int of = RoadPathCalculator.oceanFloorSampler(x, z, level);
        int sea = level.m_5736_();
        boolean bl = res = ws > of && ws >= sea;
        if (res && level.m_46749_(check = new BlockPos(x, Math.max(sea - 1, ws - 1), z))) {
            res = level.m_6425_(check).m_205070_(FluidTags.f_13131_);
        }
        columnWaterCache.put(key, res);
        return res;
    }

    static int snapToGrid(int v, int gridSize) {
        return Math.floorDiv(v, gridSize) * gridSize;
    }

    static Set<BlockPos> generateWidth(BlockPos center, int radius, Set<BlockPos> cache, RoadDirection dir) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        int cx = center.m_123341_();
        int cz = center.m_123343_();
        int y = 0;
        if (dir == RoadDirection.X_AXIS) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos p = new BlockPos(cx, y, cz + dz);
                if (!cache.add(p)) continue;
                set.add(p);
            }
        } else if (dir == RoadDirection.Z_AXIS) {
            for (int dx = -radius; dx <= radius; ++dx) {
                BlockPos p = new BlockPos(cx + dx, y, cz);
                if (!cache.add(p)) continue;
                set.add(p);
            }
        } else {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos p;
                    if (dir == RoadDirection.DIAGONAL_2 && (dx == -radius && dz == -radius || dx == radius && dz == radius) || dir == RoadDirection.DIAGONAL_1 && (dx == -radius && dz == radius || dx == radius && dz == -radius) || !cache.add(p = new BlockPos(cx + dx, y, cz + dz))) continue;
                    set.add(p);
                }
            }
        }
        return set;
    }

    public static List<Records.RoadSpan> extractSpans(List<Records.RoadSegmentPlacement> segments, ServerLevel level) {
        int len;
        ArrayList<Records.RoadSpan> spans = new ArrayList<Records.RoadSpan>();
        if (segments == null || segments.isEmpty()) {
            return spans;
        }
        ArrayList<BlockPos> centers = new ArrayList<BlockPos>(segments.size());
        for (Records.RoadSegmentPlacement seg : segments) {
            centers.add(seg.middlePos());
        }
        boolean inWater = false;
        int waterStart = -1;
        for (int i = 0; i < centers.size(); ++i) {
            BlockPos p = (BlockPos)centers.get(i);
            boolean water = RoadPathCalculator.isColumnWater(p.m_123341_(), p.m_123343_(), level);
            if (water && !inWater) {
                inWater = true;
                waterStart = i;
                continue;
            }
            if (water || !inWater) continue;
            int startIdx = Math.max(0, waterStart - 1);
            int endIdx = i;
            BlockPos start = (BlockPos)centers.get(startIdx);
            BlockPos end = (BlockPos)centers.get(Math.min(endIdx, centers.size() - 1));
            spans.add(new Records.RoadSpan(start, end, Records.SpanType.BRIDGE));
            inWater = false;
            waterStart = -1;
        }
        int SLOPE_ABS_THRESHOLD = 4;
        int RUN_MIN_LENGTH = 3;
        int runStart = -1;
        for (int i = 1; i < centers.size(); ++i) {
            boolean steep;
            BlockPos a = (BlockPos)centers.get(i - 1);
            BlockPos b = (BlockPos)centers.get(i);
            int ya = RoadPathCalculator.heightSampler(a.m_123341_(), a.m_123343_(), level);
            int yb = RoadPathCalculator.heightSampler(b.m_123341_(), b.m_123343_(), level);
            int dy = Math.abs(yb - ya);
            boolean bl = steep = dy >= 4;
            if (steep) {
                if (runStart >= 0) continue;
                runStart = i - 1;
                continue;
            }
            if (runStart < 0) continue;
            int len2 = i - runStart;
            if (len2 >= 3) {
                BlockPos s = (BlockPos)centers.get(runStart);
                BlockPos e = (BlockPos)centers.get(i);
                spans.add(new Records.RoadSpan(s, e, Records.SpanType.TUNNEL));
            }
            runStart = -1;
        }
        if (runStart >= 0 && (len = centers.size() - runStart) >= 3) {
            BlockPos s = (BlockPos)centers.get(runStart);
            BlockPos e = (BlockPos)centers.get(centers.size() - 1);
            spans.add(new Records.RoadSpan(s, e, Records.SpanType.TUNNEL));
        }
        return spans;
    }
}

