/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.helpers.Records;

public final class MapSnapshotCodec {
    private MapSnapshotCodec() {
    }

    public static void write(FriendlyByteBuf buf, MapSnapshot s) {
        List<BlockPos> structures = s.structures();
        List<Records.StructureConnection> conns = s.connections();
        buf.m_130130_(structures.size());
        for (BlockPos p : structures) {
            buf.m_130064_(p);
        }
        for (BlockPos p : structures) {
            String name = s.structureName(p);
            boolean has = name != null;
            buf.writeBoolean(has);
            if (!has) continue;
            buf.m_130070_(name);
        }
        buf.m_130130_(conns.size());
        for (Records.StructureConnection c : conns) {
            buf.m_130064_(c.from());
            buf.m_130064_(c.to());
            buf.m_130130_(c.status().ordinal());
        }
        List<List<BlockPos>> roads = s.roadPolylines();
        buf.m_130130_(roads.size());
        for (List<BlockPos> pl : roads) {
            buf.m_130130_(pl.size());
            for (BlockPos p : pl) {
                buf.m_130064_(p);
            }
        }
    }

    public static MapSnapshot read(FriendlyByteBuf buf) {
        int sc = buf.m_130242_();
        ArrayList<BlockPos> structures = new ArrayList<BlockPos>(sc);
        for (int i = 0; i < sc; ++i) {
            structures.add(buf.m_130135_());
        }
        ArrayList<Records.StructureInfo> infos = new ArrayList<Records.StructureInfo>(sc);
        for (int i = 0; i < sc; ++i) {
            boolean has = buf.readBoolean();
            if (!has) continue;
            String id = buf.m_130277_();
            infos.add(new Records.StructureInfo((BlockPos)structures.get(i), id));
        }
        int cc = buf.m_130242_();
        ArrayList<Records.StructureConnection> conns = new ArrayList<Records.StructureConnection>(cc);
        for (int i = 0; i < cc; ++i) {
            BlockPos a = buf.m_130135_();
            BlockPos b = buf.m_130135_();
            int ord = buf.m_130242_();
            Records.ConnectionStatus st = Records.ConnectionStatus.values()[ord];
            conns.add(new Records.StructureConnection(a, b, st));
        }
        int rp = buf.m_130242_();
        ArrayList<List<BlockPos>> roads = new ArrayList<List<BlockPos>>(rp);
        for (int i = 0; i < rp; ++i) {
            int pc = buf.m_130242_();
            ArrayList<BlockPos> poly = new ArrayList<BlockPos>(pc);
            for (int j = 0; j < pc; ++j) {
                poly.add(buf.m_130135_());
            }
            roads.add(poly);
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }
}

