/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.forge.WorldDataProviderImpl;

public abstract class WorldDataProvider {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static WorldDataProvider getInstance() {
        return WorldDataProviderImpl.getInstance();
    }

    public abstract Records.StructureLocationData getStructureLocations(ServerLevel var1);

    public abstract void setStructureLocations(ServerLevel var1, Records.StructureLocationData var2);

    public abstract List<Records.StructureConnection> getStructureConnections(ServerLevel var1);

    public abstract void setStructureConnections(ServerLevel var1, List<Records.StructureConnection> var2);

    public abstract List<Records.RoadData> getRoadDataList(ServerLevel var1);

    public abstract void setRoadDataList(ServerLevel var1, List<Records.RoadData> var2);

    public void addStructureLocation(ServerLevel level, BlockPos pos) {
        Records.StructureLocationData data = this.getStructureLocations(level);
        ArrayList<BlockPos> locations = new ArrayList<BlockPos>(data.structureLocations());
        if (!locations.contains(pos)) {
            locations.add(pos);
            this.setStructureLocations(level, new Records.StructureLocationData(locations));
        }
    }
}

