/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence.forge;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public class ForgeWorldDataProvider
extends WorldDataProvider {
    private static final String DATA_NAME = "roadweaver_world_data";

    private Data getOrCreate(ServerLevel level) {
        return (Data)level.m_8895_().m_164861_(Data::load, Data::new, DATA_NAME);
    }

    @Override
    public Records.StructureLocationData getStructureLocations(ServerLevel level) {
        return this.getOrCreate(level).getStructureLocations();
    }

    @Override
    public void setStructureLocations(ServerLevel level, Records.StructureLocationData data) {
        this.getOrCreate(level).setStructureLocations(data);
    }

    @Override
    public List<Records.StructureConnection> getStructureConnections(ServerLevel level) {
        return this.getOrCreate(level).getConnections();
    }

    @Override
    public void setStructureConnections(ServerLevel level, List<Records.StructureConnection> connections) {
        this.getOrCreate(level).setConnections(connections);
    }

    @Override
    public List<Records.RoadData> getRoadDataList(ServerLevel level) {
        return this.getOrCreate(level).getRoadDataList();
    }

    @Override
    public void setRoadDataList(ServerLevel level, List<Records.RoadData> roadDataList) {
        this.getOrCreate(level).setRoadDataList(roadDataList);
    }

    public static class Data
    extends SavedData {
        private Records.StructureLocationData structureLocations = new Records.StructureLocationData(new ArrayList<BlockPos>());
        private List<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>();
        private List<Records.RoadData> roadDataList = new ArrayList<Records.RoadData>();
        private static final String KEY_LOCATIONS = "structure_locations";
        private static final String KEY_CONNECTIONS = "connections";
        private static final String KEY_ROAD_DATA_LIST = "road_chunk_data_map";

        public static Data load(CompoundTag tag) {
            DataResult res;
            Data data = new Data();
            NbtOps ops = NbtOps.f_128958_;
            if (tag.m_128441_(KEY_LOCATIONS)) {
                Tag locTag = tag.m_128423_(KEY_LOCATIONS);
                res = Records.StructureLocationData.CODEC.parse(new Dynamic((DynamicOps)ops, (Object)locTag));
                res.result().ifPresent(val -> {
                    data.structureLocations = val;
                });
            }
            if (tag.m_128441_(KEY_CONNECTIONS)) {
                Tag conTag = tag.m_128423_(KEY_CONNECTIONS);
                res = Codec.list(Records.StructureConnection.CODEC).parse(new Dynamic((DynamicOps)ops, (Object)conTag));
                res.result().ifPresent(val -> {
                    data.connections = val;
                });
            }
            if (tag.m_128441_(KEY_ROAD_DATA_LIST)) {
                Tag roadTag = tag.m_128423_(KEY_ROAD_DATA_LIST);
                res = Codec.list(Records.RoadData.CODEC).parse(new Dynamic((DynamicOps)ops, (Object)roadTag));
                res.result().ifPresent(val -> {
                    data.roadDataList = val;
                });
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            NbtOps ops = NbtOps.f_128958_;
            Records.StructureLocationData.CODEC.encodeStart((DynamicOps)ops, (Object)this.structureLocations).result().ifPresent(nbt -> tag.m_128365_(KEY_LOCATIONS, nbt));
            Codec.list(Records.StructureConnection.CODEC).encodeStart((DynamicOps)ops, this.connections).result().ifPresent(nbt -> tag.m_128365_(KEY_CONNECTIONS, nbt));
            Codec.list(Records.RoadData.CODEC).encodeStart((DynamicOps)ops, this.roadDataList).result().ifPresent(nbt -> tag.m_128365_(KEY_ROAD_DATA_LIST, nbt));
            return tag;
        }

        public Records.StructureLocationData getStructureLocations() {
            return this.structureLocations;
        }

        public void setStructureLocations(Records.StructureLocationData data) {
            this.structureLocations = Objects.requireNonNullElseGet(data, () -> new Records.StructureLocationData(new ArrayList<BlockPos>()));
            this.m_77762_();
        }

        public List<Records.StructureConnection> getConnections() {
            return this.connections;
        }

        public void setConnections(List<Records.StructureConnection> connections) {
            this.connections = Objects.requireNonNullElseGet(connections, ArrayList::new);
            this.m_77762_();
        }

        public List<Records.RoadData> getRoadDataList() {
            return this.roadDataList;
        }

        public void setRoadDataList(List<Records.RoadData> list) {
            this.roadDataList = Objects.requireNonNullElseGet(list, ArrayList::new);
            this.m_77762_();
        }
    }
}

