/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.bridge;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.bridge.BridgeBuilder;
import net.shiroha233.roadweaver.helpers.Records;

public final class BridgeSegmentPlanner {
    private BridgeSegmentPlanner() {
    }

    public static Context newContext() {
        return new Context();
    }

    private static int clampDeckY(int candidateDeckY, Integer lastDeckY, int deckY, ModConfig cfg, boolean inRamp, boolean approachDeck) {
        int segDeckY = candidateDeckY;
        if (lastDeckY != null) {
            int stepDeck = Math.max(0, Math.min(8, cfg.maxSlopeStepPerTwoSegments()));
            if (cfg.slopeLimitEnabled() && stepDeck > 0) {
                if (segDeckY > lastDeckY + stepDeck) {
                    segDeckY = lastDeckY + stepDeck;
                }
                if (segDeckY < lastDeckY - stepDeck) {
                    segDeckY = lastDeckY - stepDeck;
                }
            }
            if (inRamp) {
                int prevDist = Math.abs(lastDeckY - deckY);
                int newDist = Math.abs(segDeckY - deckY);
                if (approachDeck) {
                    if (newDist > prevDist) {
                        segDeckY = lastDeckY;
                    }
                } else if (newDist < prevDist) {
                    segDeckY = lastDeckY;
                }
            }
        }
        return segDeckY;
    }

    public static void processSegment(class_5281 world, Records.RoadSegmentPlacement seg, class_2338 middle, class_2338 prev, class_2338 next, int roadWidth, int baseYForThis, int deckY, int segmentIndex, class_5819 random, ModConfig cfg, List<int[]> bridgeRanges, int i, Context ctx) {
        int rampN;
        int segDeckY = deckY;
        boolean placePier = true;
        boolean placeRail = true;
        boolean inRamp = false;
        boolean approachDeck = false;
        if (!ctx.insideBridgeRange) {
            for (int[] r : bridgeRanges) {
                if (i < r[0] || i > r[1]) continue;
                ctx.insideBridgeRange = true;
                ctx.currentRangeEnd = r[1];
                break;
            }
            ctx.lastBridgeDeckY = null;
        }
        if ((rampN = Math.max(0, cfg.bridgeRampSegments())) > 0 && !bridgeRanges.isEmpty()) {
            for (int[] r : bridgeRanges) {
                if (i < r[0] || i > r[1]) continue;
                int dStart = i - r[0];
                int dEnd = r[1] - i;
                if (dStart >= rampN && dEnd >= rampN) break;
                inRamp = true;
                approachDeck = dStart <= dEnd;
                double f = dStart < rampN ? (double)dStart / (double)rampN : (double)dEnd / (double)rampN;
                f = Math.max(0.0, Math.min(1.0, f));
                int rampBaseY = baseYForThis;
                segDeckY = (int)Math.round((double)rampBaseY + (double)(deckY - rampBaseY) * f);
                placePier = false;
                placeRail = false;
                break;
            }
        }
        if (placeRail && !bridgeRanges.isEmpty()) {
            for (int[] r : bridgeRanges) {
                if (i != r[0] && i != r[1]) continue;
                placeRail = false;
                break;
            }
        }
        segDeckY = BridgeSegmentPlanner.clampDeckY(segDeckY, ctx.lastBridgeDeckY, deckY, cfg, inRamp, approachDeck);
        ctx.lastBridgeDeckY = segDeckY;
        if (ctx.insideBridgeRange && i >= ctx.currentRangeEnd) {
            ctx.insideBridgeRange = false;
            ctx.currentRangeEnd = -1;
            ctx.lastBridgeDeckY = null;
        }
        BridgeBuilder.placeSegment(world, seg, middle, prev, next, roadWidth, segDeckY, segmentIndex, random, cfg, placePier, placeRail);
    }

    public static final class Context {
        public boolean insideBridgeRange = false;
        public int currentRangeEnd = -1;
        public Integer lastBridgeDeckY = null;
    }
}

