/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.roadlogic.core.RoadDirection;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.BasicAStarPathfinder;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.BidirectionalAStarPathfinder;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.GradientDescentPathfinder;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

public final class RoadPathCalculator {
    private RoadPathCalculator() {
    }

    static int getNeighborDistance() {
        try {
            int v = ConfigService.get().aStarStep();
            if (v < 4) {
                return 16;
            }
            if (v > 128) {
                return 128;
            }
            return v;
        }
        catch (Throwable ignore) {
            return 16;
        }
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(class_2338 startIn, class_2338 endIn, int width, class_3218 level, int maxSteps, TerrainSamplingCache cache) {
        int dGrid = RoadPathCalculator.getNeighborDistance();
        int sx = RoadPathCalculator.snapToGrid(startIn.method_10263(), dGrid);
        int sz = RoadPathCalculator.snapToGrid(startIn.method_10260(), dGrid);
        int ex = RoadPathCalculator.snapToGrid(endIn.method_10263(), dGrid);
        int ez = RoadPathCalculator.snapToGrid(endIn.method_10260(), dGrid);
        class_2338 start = new class_2338(sx, startIn.method_10264(), sz);
        class_2338 end = new class_2338(ex, endIn.method_10264(), ez);
        class_2338 startGround = new class_2338(start.method_10263(), RoadPathCalculator.heightSampler(cache, start.method_10263(), start.method_10260(), level), start.method_10260());
        class_2338 endGround = new class_2338(end.method_10263(), RoadPathCalculator.heightSampler(cache, end.method_10263(), end.method_10260(), level), end.method_10260());
        ModConfig.PathfindingAlgorithm algo = ConfigService.get().pathfindingAlgorithm();
        List<Records.RoadSegmentPlacement> land = algo == ModConfig.PathfindingAlgorithm.GRADIENT_DESCENT ? GradientDescentPathfinder.calculatePath(startGround, endGround, width, level, maxSteps, cache) : (algo == ModConfig.PathfindingAlgorithm.ASTAR_BIDIRECTIONAL ? BidirectionalAStarPathfinder.calculateLandPath(startGround, endGround, width, level, maxSteps, cache) : BasicAStarPathfinder.calculateLandPath(startGround, endGround, width, level, maxSteps, cache));
        return land;
    }

    static int calculateTerrainStability(TerrainSamplingCache cache, class_2338 pos, int y, class_3218 level) {
        int cost = 0;
        if (Math.abs(RoadPathCalculator.heightSampler(cache, pos.method_10263() + 1, pos.method_10260(), level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(cache, pos.method_10263() - 1, pos.method_10260(), level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(cache, pos.method_10263(), pos.method_10260() + 1, level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(cache, pos.method_10263(), pos.method_10260() - 1, level) - y) > 0) {
            ++cost;
        }
        return cost;
    }

    static int heightSampler(TerrainSamplingCache cache, int x, int z, class_3218 level) {
        return cache.height(level, x, z);
    }

    static boolean isWaterLike(TerrainSamplingCache cache, int x, int z, class_3218 level) {
        return cache.isWaterLike(level, x, z);
    }

    static int oceanFloorSampler(TerrainSamplingCache cache, int x, int z, class_3218 level) {
        return cache.oceanFloor(level, x, z);
    }

    static boolean isNearWaterLike(TerrainSamplingCache cache, int x, int z, class_3218 level) {
        int d = RoadPathCalculator.getNeighborDistance();
        return cache.isNearWaterLike(level, x, z, d);
    }

    static boolean isColumnWater(TerrainSamplingCache cache, int x, int z, class_3218 level) {
        return cache.isColumnWater(level, x, z);
    }

    static int snapToGrid(int v, int gridSize) {
        return Math.floorDiv(v, gridSize) * gridSize;
    }

    static Set<class_2338> generateWidth(class_2338 center, int radius, Set<class_2338> cache, RoadDirection dir) {
        HashSet<class_2338> set = new HashSet<class_2338>();
        int cx = center.method_10263();
        int cz = center.method_10260();
        int y = 0;
        if (dir == RoadDirection.X_AXIS) {
            for (int dz = -radius; dz <= radius; ++dz) {
                class_2338 p = new class_2338(cx, y, cz + dz);
                if (!cache.add(p)) continue;
                set.add(p);
            }
        } else if (dir == RoadDirection.Z_AXIS) {
            for (int dx = -radius; dx <= radius; ++dx) {
                class_2338 p = new class_2338(cx + dx, y, cz);
                if (!cache.add(p)) continue;
                set.add(p);
            }
        } else {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 p;
                    if (dir == RoadDirection.DIAGONAL_2 && (dx == -radius && dz == -radius || dx == radius && dz == radius) || dir == RoadDirection.DIAGONAL_1 && (dx == -radius && dz == radius || dx == radius && dz == -radius) || !cache.add(p = new class_2338(cx + dx, y, cz + dz))) continue;
                    set.add(p);
                }
            }
        }
        return set;
    }

    public static List<Records.RoadSpan> extractSpans(List<Records.RoadSegmentPlacement> segments, class_3218 level, TerrainSamplingCache cache) {
        int len;
        ArrayList<Records.RoadSpan> spans = new ArrayList<Records.RoadSpan>();
        if (segments == null || segments.isEmpty()) {
            return spans;
        }
        ArrayList<class_2338> centers = new ArrayList<class_2338>(segments.size());
        for (Records.RoadSegmentPlacement seg : segments) {
            centers.add(seg.middlePos());
        }
        boolean inWater = false;
        int waterStart = -1;
        for (int i = 0; i < centers.size(); ++i) {
            class_2338 p = (class_2338)centers.get(i);
            boolean water = RoadPathCalculator.isColumnWater(cache, p.method_10263(), p.method_10260(), level);
            if (water && !inWater) {
                inWater = true;
                waterStart = i;
                continue;
            }
            if (water || !inWater) continue;
            int startIdx = Math.max(0, waterStart - 1);
            int endIdx = i;
            class_2338 start = (class_2338)centers.get(startIdx);
            class_2338 end = (class_2338)centers.get(Math.min(endIdx, centers.size() - 1));
            spans.add(new Records.RoadSpan(start, end, Records.SpanType.BRIDGE));
            inWater = false;
            waterStart = -1;
        }
        int SLOPE_ABS_THRESHOLD = 4;
        int RUN_MIN_LENGTH = 3;
        int runStart = -1;
        for (int i = 1; i < centers.size(); ++i) {
            boolean steep;
            class_2338 a = (class_2338)centers.get(i - 1);
            class_2338 b = (class_2338)centers.get(i);
            int ya = RoadPathCalculator.heightSampler(cache, a.method_10263(), a.method_10260(), level);
            int yb = RoadPathCalculator.heightSampler(cache, b.method_10263(), b.method_10260(), level);
            int dy = Math.abs(yb - ya);
            boolean bl = steep = dy >= 4;
            if (steep) {
                if (runStart >= 0) continue;
                runStart = i - 1;
                continue;
            }
            if (runStart < 0) continue;
            int len2 = i - runStart;
            if (len2 >= 3) {
                class_2338 s = (class_2338)centers.get(runStart);
                class_2338 e = (class_2338)centers.get(i);
                spans.add(new Records.RoadSpan(s, e, Records.SpanType.TUNNEL));
            }
            runStart = -1;
        }
        if (runStart >= 0 && (len = centers.size() - runStart) >= 3) {
            class_2338 s = (class_2338)centers.get(runStart);
            class_2338 e = (class_2338)centers.get(centers.size() - 1);
            spans.add(new Records.RoadSpan(s, e, Records.SpanType.TUNNEL));
        }
        return spans;
    }
}

