/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.action;

import cc.carm.lib.easysql.action.AbstractSQLAction;
import cc.carm.lib.easysql.api.action.SQLUpdateBatchAction;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SQLUpdateBatchActionImpl
extends AbstractSQLAction<List<Integer>>
implements SQLUpdateBatchAction {
    protected final List<String> sqlContents = new ArrayList<String>();

    public SQLUpdateBatchActionImpl(@NotNull SQLManagerImpl manager, @NotNull String sql) {
        super(manager, sql);
        this.sqlContents.add(sql);
    }

    @Override
    @NotNull
    public List<String> getSQLContents() {
        return this.sqlContents;
    }

    @Override
    public SQLUpdateBatchAction addBatch(@NotNull String sql) {
        Objects.requireNonNull(sql, "sql could not be null");
        this.sqlContents.add(sql);
        return this;
    }

    @Override
    @NotNull
    public List<Integer> execute() throws SQLException {
        this.debugMessage(new ArrayList<Object[]>());
        try (Connection connection = this.getManager().getConnection();){
            List<Integer> list;
            block13: {
                Statement statement = connection.createStatement();
                try {
                    for (String content : this.sqlContents) {
                        statement.addBatch(content);
                    }
                    int[] executed = statement.executeBatch();
                    list = Arrays.stream(executed).boxed().collect(Collectors.toList());
                    if (statement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
    }
}

