/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.function.SQLExceptionHandler;
import cc.carm.lib.easysql.api.function.SQLFunction;
import cc.carm.lib.easysql.api.function.SQLHandler;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SQLAction<T> {
    @NotNull
    public UUID getActionUUID();

    @NotNull
    public String getShortID();

    default public long getCreateTime() {
        return this.getCreateTime(TimeUnit.MILLISECONDS);
    }

    public long getCreateTime(TimeUnit var1);

    @NotNull
    public String getSQLContent();

    @NotNull
    default public List<String> getSQLContents() {
        return Collections.singletonList(this.getSQLContent());
    }

    @NotNull
    public SQLManager getManager();

    @NotNull
    public T execute() throws SQLException;

    @Nullable
    default public T execute(@Nullable SQLExceptionHandler exceptionHandler) {
        return (T)this.execute(t -> t, exceptionHandler);
    }

    @Nullable
    default public <R> R execute(@NotNull SQLFunction<T, R> function, @Nullable SQLExceptionHandler exceptionHandler) {
        return this.execute(function, null, exceptionHandler);
    }

    @Nullable
    @Contract(value="_,!null,_ -> !null")
    default public <R> R execute(@NotNull SQLFunction<T, R> function, @Nullable R defaultResult, @Nullable SQLExceptionHandler exceptionHandler) {
        try {
            return this.executeFunction(function, defaultResult);
        }
        catch (SQLException exception) {
            this.handleException(exceptionHandler, exception);
            return null;
        }
    }

    @Nullable
    default public <R> R executeFunction(@NotNull @NotNull SQLFunction<@NotNull T, R> function) throws SQLException {
        return this.executeFunction(function, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    default public <R> R executeFunction(@NotNull @NotNull SQLFunction<@NotNull T, R> function, @Nullable R defaultResult) throws SQLException {
        try {
            R result = function.apply(this.execute());
            return result == null ? defaultResult : result;
        }
        catch (SQLException exception) {
            throw new SQLException(exception);
        }
    }

    default public void executeAsync() {
        this.executeAsync(null);
    }

    default public void executeAsync(@Nullable SQLHandler<T> success) {
        this.executeAsync(success, null);
    }

    public void executeAsync(@Nullable SQLHandler<T> var1, @Nullable SQLExceptionHandler var2);

    default public void handleException(@Nullable SQLExceptionHandler handler, SQLException exception) {
        if (handler == null) {
            handler = this.defaultExceptionHandler();
        }
        handler.accept(exception, this);
    }

    default public SQLExceptionHandler defaultExceptionHandler() {
        return this.getManager().getExceptionHandler();
    }

    default public void setExceptionHandler(@Nullable SQLExceptionHandler handler) {
        this.getManager().setExceptionHandler(handler);
    }
}

