/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api.builder;

import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.action.SQLUpdateAction;
import cc.carm.lib.easysql.api.enums.ForeignKeyRule;
import cc.carm.lib.easysql.api.enums.IndexType;
import cc.carm.lib.easysql.api.enums.NumberType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TableCreateBuilder
extends SQLBuilder {
    public SQLUpdateAction<Integer> build();

    @NotNull
    public String getTableName();

    @NotNull
    public String getTableSettings();

    public TableCreateBuilder setTableSettings(@NotNull String var1);

    public TableCreateBuilder setTableComment(@Nullable String var1);

    public TableCreateBuilder setColumns(String ... var1);

    public TableCreateBuilder addColumn(@NotNull String var1);

    default public TableCreateBuilder addColumn(@NotNull String columnName, @NotNull String settings) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        return this.addColumn(SQLBuilder.withBackQuote(columnName) + " " + settings);
    }

    default public TableCreateBuilder addColumn(@NotNull String columnName, @NotNull String settings, @NotNull String comments) {
        return this.addColumn(columnName, settings + " COMMENT " + SQLBuilder.withQuote(comments));
    }

    public TableCreateBuilder addAutoIncrementColumn(@NotNull String var1, @Nullable NumberType var2, boolean var3, boolean var4);

    default public TableCreateBuilder addAutoIncrementColumn(@NotNull String columnName, boolean asPrimaryKey, boolean unsigned) {
        return this.addAutoIncrementColumn(columnName, NumberType.INT, asPrimaryKey, unsigned);
    }

    default public TableCreateBuilder addAutoIncrementColumn(@NotNull String columnName, boolean asPrimaryKey) {
        return this.addAutoIncrementColumn(columnName, asPrimaryKey, true);
    }

    default public TableCreateBuilder addAutoIncrementColumn(@NotNull String columnName) {
        return this.addAutoIncrementColumn(columnName, true);
    }

    default public TableCreateBuilder setIndex(@NotNull String columnName, @NotNull IndexType type) {
        return this.setIndex(type, null, columnName, new String[0]);
    }

    public TableCreateBuilder setIndex(@NotNull IndexType var1, @Nullable String var2, @NotNull String var3, String ... var4);

    default public TableCreateBuilder addForeignKey(@NotNull String tableColumn, @NotNull String foreignColumn) {
        return this.addForeignKey(tableColumn, this.getTableName(), foreignColumn);
    }

    default public TableCreateBuilder addForeignKey(@NotNull String tableColumn, @NotNull String foreignTable, @NotNull String foreignColumn) {
        return this.addForeignKey(tableColumn, null, foreignTable, foreignColumn);
    }

    default public TableCreateBuilder addForeignKey(@NotNull String tableColumn, @Nullable String constraintName, @NotNull String foreignTable, @NotNull String foreignColumn) {
        return this.addForeignKey(tableColumn, constraintName, foreignTable, foreignColumn, null, null);
    }

    public TableCreateBuilder addForeignKey(@NotNull String var1, @Nullable String var2, @NotNull String var3, @NotNull String var4, @Nullable ForeignKeyRule var5, @Nullable ForeignKeyRule var6);

    default public String defaultTablesSettings() {
        return "ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }
}

