/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api.function;

import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface SQLDebugHandler {
    public void beforeExecute(@NotNull SQLAction<?> var1, @NotNull List<@Nullable Object[]> var2);

    public void afterQuery(@NotNull SQLQuery var1, long var2, long var4);

    default public String parseParams(@Nullable Object[] params) {
        if (params == null) {
            return "<#NULL>";
        }
        if (params.length == 0) {
            return "<#EMPTY>";
        }
        ArrayList<String> paramsString = new ArrayList<String>();
        for (Object param : params) {
            if (param == null) {
                paramsString.add("NULL");
                continue;
            }
            paramsString.add(param.toString());
        }
        return String.join((CharSequence)", ", paramsString);
    }

    public static SQLDebugHandler defaultHandler(final Logger logger) {
        return new SQLDebugHandler(){

            @Override
            public void beforeExecute(@NotNull SQLAction<?> action, @NotNull List<@Nullable Object[]> params) {
                int i;
                logger.info("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                logger.info("\u2523# ActionUUID: {}", (Object)action.getActionUUID());
                logger.info("\u2523# ActionType: {}", (Object)action.getClass().getSimpleName());
                if (action.getSQLContents().size() == 1) {
                    logger.info("\u2523# SQLContent: {}", (Object)action.getSQLContents().get(0));
                } else {
                    logger.info("\u2523# SQLContents: ");
                    i = 0;
                    for (String sqlContent : action.getSQLContents()) {
                        logger.info("\u2503 - [{}] {}", (Object)(++i), (Object)sqlContent);
                    }
                }
                if (params.size() == 1) {
                    Object[] param = params.get(0);
                    if (param != null) {
                        logger.info("\u2523# SQLParam: {}", (Object)this.parseParams(param));
                    }
                } else if (params.size() > 1) {
                    logger.info("\u2523# SQLParams: ");
                    i = 0;
                    for (Object[] param : params) {
                        logger.info("\u2503 - [{}] {}", (Object)(++i), (Object)this.parseParams(param));
                    }
                }
                logger.info("\u2523# CreateTime: {}", (Object)action.getCreateTime(TimeUnit.MILLISECONDS));
                logger.info("\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            }

            @Override
            public void afterQuery(@NotNull SQLQuery query, long executeNanoTime, long closeNanoTime) {
                logger.info("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                logger.info("\u2523# ActionUUID: {}", (Object)query.getAction().getActionUUID());
                logger.info("\u2523# SQLContent: {}", (Object)query.getSQLContent());
                logger.info("\u2523# CloseTime: {}  (cost {} ms)", (Object)TimeUnit.NANOSECONDS.toMillis(closeNanoTime), (Object)((double)(closeNanoTime - executeNanoTime) / 1000000.0));
                logger.info("\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            }
        };
    }
}

