/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeDateUtils {
    public static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getCurrentTime() {
        return TimeDateUtils.getTimeString(System.currentTimeMillis());
    }

    public static String getTimeString(long timeMillis) {
        return TimeDateUtils.getFormat().format(new Date(timeMillis));
    }

    public static String getTimeString(Date time) {
        return TimeDateUtils.getFormat().format(time);
    }

    public static long parseTimeMillis(String timeString) {
        if (timeString == null) {
            return -1L;
        }
        try {
            return format.parse(timeString).getTime();
        }
        catch (ParseException var2) {
            return -1L;
        }
    }

    public static Date getTimeDate(String timeString) {
        if (timeString == null) {
            return null;
        }
        try {
            return format.parse(timeString);
        }
        catch (ParseException var2) {
            return null;
        }
    }

    public static String toDHMSStyle(long allSeconds) {
        long days = allSeconds / 86400L;
        long hours = allSeconds % 86400L / 3600L;
        long minutes = allSeconds % 3600L / 60L;
        long seconds = allSeconds % 60L;
        String DateTimes = days > 0L ? days + "\u5929" + (hours > 0L ? hours + "\u5c0f\u65f6" : "") + (minutes > 0L ? minutes + "\u5206\u949f" : "") + (seconds > 0L ? seconds + "\u79d2" : "") : (hours > 0L ? hours + "\u5c0f\u65f6" + (minutes > 0L ? minutes + "\u5206\u949f" : "") + (seconds > 0L ? seconds + "\u79d2" : "") : (minutes > 0L ? minutes + "\u5206\u949f" + (seconds > 0L ? seconds + "\u79d2" : "") : seconds + "\u79d2"));
        return DateTimes;
    }

    public static DateFormat getFormat() {
        return format;
    }
}

