/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.builder.ConditionalBuilder;
import cc.carm.lib.easysql.builder.AbstractSQLBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConditionalBuilder<B extends ConditionalBuilder<B, T>, T extends SQLAction<?>>
extends AbstractSQLBuilder
implements ConditionalBuilder<B, T> {
    ArrayList<String> conditionSQLs = new ArrayList();
    ArrayList<Object> conditionParams = new ArrayList();
    int limit = -1;

    public AbstractConditionalBuilder(@NotNull SQLManagerImpl manager) {
        super(manager);
    }

    protected abstract B getThis();

    @Override
    public B setConditions(@Nullable String condition) {
        this.conditionSQLs = new ArrayList();
        this.conditionParams = new ArrayList();
        if (condition != null) {
            this.conditionSQLs.add(condition);
        }
        return this.getThis();
    }

    @Override
    public B setConditions(LinkedHashMap<@NotNull String, @Nullable Object> conditions) {
        conditions.forEach(this::addCondition);
        return this.getThis();
    }

    @Override
    public B addCondition(@Nullable String condition) {
        this.conditionSQLs.add(condition);
        return this.getThis();
    }

    @Override
    public B addCondition(@NotNull String columnName, @Nullable Object queryValue) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        if (queryValue == null) {
            return this.addCondition(SQLBuilder.withBackQuote(columnName) + " IS NULL");
        }
        return this.addCondition(columnName, "=", queryValue);
    }

    @Override
    public B addCondition(@NotNull String columnName, @NotNull String operator, @Nullable Object queryValue) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        Objects.requireNonNull(operator, "operator could not be null (e.g. > or = or <) ");
        this.addCondition(SQLBuilder.withBackQuote(columnName) + " " + operator + " ?");
        this.conditionParams.add(queryValue);
        return this.getThis();
    }

    @Override
    public B addCondition(@NotNull String[] columnNames, @Nullable Object[] queryValues) {
        Objects.requireNonNull(columnNames, "columnName could not be null");
        if (queryValues == null || columnNames.length != queryValues.length) {
            throw new RuntimeException("queryNames are not match with queryValues");
        }
        for (int i = 0; i < columnNames.length; ++i) {
            this.addCondition(columnNames[i], queryValues[i]);
        }
        return this.getThis();
    }

    @Override
    public B addNotNullCondition(@NotNull String columnName) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        return this.addCondition(SQLBuilder.withBackQuote(columnName) + " IS NOT NULL");
    }

    @Override
    public B addTimeCondition(@NotNull String columnName, @Nullable Date startDate, @Nullable Date endDate) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        if (startDate == null && endDate == null) {
            return this.getThis();
        }
        if (startDate != null) {
            this.addCondition(SQLBuilder.withBackQuote(columnName) + " BETWEEN ? AND ?");
            this.conditionParams.add(startDate);
            if (endDate != null) {
                this.conditionParams.add(endDate);
            } else if (startDate instanceof java.sql.Date) {
                this.conditionParams.add(new java.sql.Date(System.currentTimeMillis()));
            } else if (startDate instanceof Time) {
                this.conditionParams.add(new Time(System.currentTimeMillis()));
            } else {
                this.conditionParams.add(new Timestamp(System.currentTimeMillis()));
            }
        } else {
            this.addCondition(columnName, "<=", endDate);
        }
        return this.getThis();
    }

    @Override
    public B setLimit(int limit) {
        this.limit = limit;
        return this.getThis();
    }

    protected String buildConditionSQL() {
        if (!this.conditionSQLs.isEmpty()) {
            StringBuilder conditionBuilder = new StringBuilder();
            conditionBuilder.append("WHERE").append(" ");
            Iterator<String> iterator = this.conditionSQLs.iterator();
            while (iterator.hasNext()) {
                conditionBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                conditionBuilder.append(" AND ");
            }
            return conditionBuilder.toString().trim();
        }
        return null;
    }

    protected String buildLimitSQL() {
        return this.limit > 0 ? "LIMIT " + this.limit : "";
    }

    protected ArrayList<Object> getConditionParams() {
        return this.conditionParams;
    }

    protected boolean hasConditions() {
        return this.conditionSQLs != null && !this.conditionSQLs.isEmpty();
    }

    protected boolean hasConditionParams() {
        return this.hasConditions() && this.getConditionParams() != null && !this.getConditionParams().isEmpty();
    }
}

