/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.action.PreparedSQLUpdateActionImpl;
import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import cc.carm.lib.easysql.builder.impl.AbstractConditionalBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateBuilderImpl
extends AbstractConditionalBuilder<UpdateBuilder, SQLAction<Integer>>
implements UpdateBuilder {
    @NotNull
    protected final String tableName;
    @NotNull
    LinkedHashMap<String, Object> columnData;

    public UpdateBuilderImpl(@NotNull SQLManagerImpl manager, @NotNull String tableName) {
        super(manager);
        this.tableName = tableName;
        this.columnData = new LinkedHashMap();
    }

    @Override
    public PreparedSQLUpdateAction<Integer> build() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE ").append(SQLBuilder.withBackQuote(this.getTableName())).append(" SET ");
        Iterator<String> iterator = this.columnData.keySet().iterator();
        while (iterator.hasNext()) {
            sqlBuilder.append(SQLBuilder.withBackQuote(iterator.next())).append(" = ?");
            if (!iterator.hasNext()) continue;
            sqlBuilder.append(" , ");
        }
        ArrayList<Object> allParams = new ArrayList<Object>(this.columnData.values());
        if (this.hasConditions()) {
            sqlBuilder.append(" ").append(this.buildConditionSQL());
            allParams.addAll(this.getConditionParams());
        }
        if (this.limit > 0) {
            sqlBuilder.append(" ").append(this.buildLimitSQL());
        }
        return new PreparedSQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, sqlBuilder.toString(), allParams);
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public UpdateBuilder addColumnValue(@NotNull String columnName, Object columnValue) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        this.columnData.put(columnName, columnValue);
        return this;
    }

    @Override
    public UpdateBuilder setColumnValues(LinkedHashMap<String, Object> columnData) {
        this.columnData = columnData;
        return this;
    }

    @Override
    public UpdateBuilder setColumnValues(@NotNull String[] columnNames, @Nullable Object[] columnValues) {
        Objects.requireNonNull(columnNames, "columnName could not be null");
        if (columnNames.length != columnValues.length) {
            throw new RuntimeException("columnNames are not match with columnValues");
        }
        LinkedHashMap<String, Object> columnData = new LinkedHashMap<String, Object>();
        for (int i = 0; i < columnNames.length; ++i) {
            columnData.put(columnNames[i], columnValues[i]);
        }
        return this.setColumnValues(columnData);
    }

    @Override
    protected UpdateBuilder getThis() {
        return this;
    }
}

