/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.manager;

import cc.carm.lib.easysql.action.PreparedSQLBatchUpdateActionImpl;
import cc.carm.lib.easysql.action.PreparedSQLUpdateActionImpl;
import cc.carm.lib.easysql.action.SQLUpdateActionImpl;
import cc.carm.lib.easysql.action.SQLUpdateBatchActionImpl;
import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateBatchAction;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.api.builder.InsertBuilder;
import cc.carm.lib.easysql.api.builder.QueryBuilder;
import cc.carm.lib.easysql.api.builder.ReplaceBuilder;
import cc.carm.lib.easysql.api.builder.TableAlterBuilder;
import cc.carm.lib.easysql.api.builder.TableCreateBuilder;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import cc.carm.lib.easysql.api.function.SQLDebugHandler;
import cc.carm.lib.easysql.api.function.SQLExceptionHandler;
import cc.carm.lib.easysql.builder.impl.DeleteBuilderImpl;
import cc.carm.lib.easysql.builder.impl.InsertBuilderImpl;
import cc.carm.lib.easysql.builder.impl.QueryBuilderImpl;
import cc.carm.lib.easysql.builder.impl.ReplaceBuilderImpl;
import cc.carm.lib.easysql.builder.impl.TableAlterBuilderImpl;
import cc.carm.lib.easysql.builder.impl.TableCreateBuilderImpl;
import cc.carm.lib.easysql.builder.impl.UpdateBuilderImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLManagerImpl
implements SQLManager {
    private final Logger LOGGER;
    private final DataSource dataSource;
    private final ConcurrentHashMap<UUID, SQLQuery> activeQuery = new ConcurrentHashMap();
    protected ExecutorService executorPool;
    @NotNull
    Supplier<Boolean> debugMode = () -> Boolean.FALSE;
    @NotNull
    SQLExceptionHandler exceptionHandler;
    @NotNull
    SQLDebugHandler debugHandler;

    public SQLManagerImpl(@NotNull DataSource dataSource) {
        this(dataSource, null);
    }

    public SQLManagerImpl(@NotNull DataSource dataSource, @Nullable String name) {
        this(dataSource, LoggerFactory.getLogger(SQLManagerImpl.class), name);
    }

    public SQLManagerImpl(@NotNull DataSource dataSource, @NotNull Logger logger, @Nullable String name) {
        String managerName = "SQLManager" + (name != null ? "#" + name : "");
        this.LOGGER = logger;
        this.dataSource = dataSource;
        this.executorPool = Executors.newFixedThreadPool(3, r -> {
            Thread thread = new Thread(r, managerName);
            thread.setDaemon(true);
            return thread;
        });
        this.exceptionHandler = SQLExceptionHandler.detailed(this.getLogger());
        this.debugHandler = SQLDebugHandler.defaultHandler(this.getLogger());
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode.get();
    }

    @Override
    public void setDebugMode(@NotNull @NotNull Supplier<@NotNull Boolean> debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    @NotNull
    public SQLDebugHandler getDebugHandler() {
        return this.debugHandler;
    }

    @Override
    public void setDebugHandler(@NotNull SQLDebugHandler debugHandler) {
        this.debugHandler = debugHandler;
    }

    public void debug(String msg) {
        if (this.isDebugMode()) {
            this.getLogger().info("[DEBUG] " + msg);
        }
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    @NotNull
    public ExecutorService getExecutorPool() {
        return this.executorPool;
    }

    @Override
    public void setExecutorPool(@NotNull ExecutorService executorPool) {
        this.executorPool = executorPool;
    }

    @Override
    @NotNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    @NotNull
    public Map<UUID, SQLQuery> getActiveQuery() {
        return this.activeQuery;
    }

    @Override
    @NotNull
    public SQLExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(@Nullable SQLExceptionHandler handler) {
        this.exceptionHandler = handler == null ? SQLExceptionHandler.detailed(this.getLogger()) : handler;
    }

    @Override
    public Integer executeSQL(String sql) {
        return (Integer)new SQLUpdateActionImpl<Integer>(this, Integer.class, sql).execute(null);
    }

    @Override
    public Integer executeSQL(String sql, Object[] params) {
        return (Integer)new PreparedSQLUpdateActionImpl<Integer>(this, Integer.class, sql, params).execute(null);
    }

    @Override
    public List<Integer> executeSQLBatch(String sql, Iterable<Object[]> paramsBatch) {
        return (List)new PreparedSQLBatchUpdateActionImpl<Integer>(this, Integer.class, sql).setAllParams((Iterable)paramsBatch).execute(null);
    }

    @Override
    public List<Integer> executeSQLBatch(@NotNull String sql, String ... moreSQL) {
        SQLUpdateBatchActionImpl action = new SQLUpdateBatchActionImpl(this, sql);
        if (moreSQL != null && moreSQL.length > 0) {
            Arrays.stream(moreSQL).forEach(action::addBatch);
        }
        return (List)action.execute(null);
    }

    @Override
    @Nullable
    public List<Integer> executeSQLBatch(@NotNull Iterable<String> sqlBatch) {
        Iterator<String> iterator = sqlBatch.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        SQLUpdateBatchActionImpl action = new SQLUpdateBatchActionImpl(this, iterator.next());
        while (iterator.hasNext()) {
            action.addBatch(iterator.next());
        }
        return (List)action.execute(null);
    }

    @Override
    public TableCreateBuilder createTable(@NotNull String tableName) {
        return new TableCreateBuilderImpl(this, tableName);
    }

    @Override
    public TableAlterBuilder alterTable(@NotNull String tableName) {
        return new TableAlterBuilderImpl(this, tableName);
    }

    @Override
    public QueryBuilder createQuery() {
        return new QueryBuilderImpl(this);
    }

    @Override
    public InsertBuilder<PreparedSQLUpdateBatchAction<Integer>> createInsertBatch(@NotNull String tableName) {
        return new InsertBuilderImpl<PreparedSQLUpdateBatchAction<Integer>>(this, tableName){

            @Override
            public PreparedSQLUpdateBatchAction<Integer> setColumnNames(List<String> columnNames) {
                return new PreparedSQLBatchUpdateActionImpl<Integer>(this.getManager(), Integer.class, 1.buildSQL(this.getTableName(), columnNames));
            }
        };
    }

    @Override
    public InsertBuilder<PreparedSQLUpdateAction<Integer>> createInsert(@NotNull String tableName) {
        return new InsertBuilderImpl<PreparedSQLUpdateAction<Integer>>(this, tableName){

            @Override
            public PreparedSQLUpdateAction<Integer> setColumnNames(List<String> columnNames) {
                return new PreparedSQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, 2.buildSQL(this.getTableName(), columnNames));
            }
        };
    }

    @Override
    public ReplaceBuilder<PreparedSQLUpdateBatchAction<Integer>> createReplaceBatch(@NotNull String tableName) {
        return new ReplaceBuilderImpl<PreparedSQLUpdateBatchAction<Integer>>(this, tableName){

            @Override
            public PreparedSQLUpdateBatchAction<Integer> setColumnNames(List<String> columnNames) {
                return new PreparedSQLBatchUpdateActionImpl<Integer>(this.getManager(), Integer.class, 3.buildSQL(this.getTableName(), columnNames));
            }
        };
    }

    @Override
    public ReplaceBuilder<PreparedSQLUpdateAction<Integer>> createReplace(@NotNull String tableName) {
        return new ReplaceBuilderImpl<PreparedSQLUpdateAction<Integer>>(this, tableName){

            @Override
            public PreparedSQLUpdateAction<Integer> setColumnNames(List<String> columnNames) {
                return new PreparedSQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, 4.buildSQL(this.getTableName(), columnNames));
            }
        };
    }

    @Override
    public UpdateBuilder createUpdate(@NotNull String tableName) {
        return new UpdateBuilderImpl(this, tableName);
    }

    @Override
    public DeleteBuilder createDelete(@NotNull String tableName) {
        return new DeleteBuilderImpl(this, tableName);
    }
}

