/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StatementUtil {
    public static PreparedStatement createPrepareStatement(Connection connection, String sql, Object[] params) throws SQLException {
        return StatementUtil.createPrepareStatement(connection, sql, params, false);
    }

    public static PreparedStatement createPrepareStatement(Connection connection, String sql, Object[] params, boolean returnGeneratedKey) throws SQLException {
        sql = sql.trim();
        PreparedStatement statement = connection.prepareStatement(sql, returnGeneratedKey ? 1 : 2);
        HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
        if (params != null) {
            StatementUtil.fillParams(statement, Arrays.asList(params), nullTypeMap);
        }
        statement.addBatch();
        return statement;
    }

    public static PreparedStatement createPrepareStatementBatch(Connection connection, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        return StatementUtil.createPrepareStatementBatch(connection, sql, paramsBatch, false);
    }

    public static PreparedStatement createPrepareStatementBatch(Connection connection, String sql, Iterable<Object[]> paramsBatch, boolean returnGeneratedKey) throws SQLException {
        sql = sql.trim();
        PreparedStatement statement = connection.prepareStatement(sql, returnGeneratedKey ? 1 : 2);
        HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
        for (Object[] params : paramsBatch) {
            StatementUtil.fillParams(statement, Arrays.asList(params), nullTypeMap);
            statement.addBatch();
        }
        return statement;
    }

    public static PreparedStatement fillParams(PreparedStatement statement, Iterable<?> params) throws SQLException {
        return StatementUtil.fillParams(statement, params, null);
    }

    public static PreparedStatement fillParams(PreparedStatement statement, Iterable<?> params, Map<Integer, Integer> nullCache) throws SQLException {
        if (null == params) {
            return statement;
        }
        int paramIndex = 1;
        for (Object param : params) {
            StatementUtil.setParam(statement, paramIndex++, param, nullCache);
        }
        return statement;
    }

    public static int getNullType(PreparedStatement statement, int paramIndex) {
        try {
            ParameterMetaData pmd = statement.getParameterMetaData();
            return pmd.getParameterType(paramIndex);
        }
        catch (SQLException ignore) {
            return 12;
        }
    }

    private static void setParam(PreparedStatement preparedStatement, int paramIndex, Object param, Map<Integer, Integer> nullCache) throws SQLException {
        if (param == null) {
            Integer type;
            Integer n = type = null == nullCache ? null : nullCache.get(paramIndex);
            if (null == type) {
                type = StatementUtil.getNullType(preparedStatement, paramIndex);
                if (null != nullCache) {
                    nullCache.put(paramIndex, type);
                }
            }
            preparedStatement.setNull(paramIndex, type);
        }
        if (param instanceof UUID) {
            preparedStatement.setString(paramIndex, param.toString());
            return;
        }
        if (param instanceof StringBuilder || param instanceof StringBuffer) {
            preparedStatement.setString(paramIndex, param.toString());
            return;
        }
        if (param instanceof Date) {
            if (param instanceof java.sql.Date) {
                preparedStatement.setDate(paramIndex, (java.sql.Date)param);
            } else if (param instanceof Time) {
                preparedStatement.setTime(paramIndex, (Time)param);
            } else {
                preparedStatement.setTimestamp(paramIndex, new Timestamp(((Date)param).getTime()));
            }
            return;
        }
        if (param instanceof Number) {
            if (param instanceof BigDecimal) {
                preparedStatement.setBigDecimal(paramIndex, (BigDecimal)param);
                return;
            }
            if (param instanceof BigInteger) {
                preparedStatement.setBigDecimal(paramIndex, new BigDecimal((BigInteger)param));
                return;
            }
        }
        if (param instanceof Enum) {
            preparedStatement.setString(paramIndex, ((Enum)param).name());
            return;
        }
        preparedStatement.setObject(paramIndex, param);
    }
}

