/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.api;

import cn.superiormc.mythicprefixes.manager.CacheManager;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.manager.ErrorManager;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.ObjectCondition;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import cn.superiormc.mythicprefixes.objects.effect.AbstractEffect;
import cn.superiormc.mythicprefixes.objects.effect.EffectStatus;
import cn.superiormc.mythicprefixes.objects.effect.ObjectAuraSkillsEffect;
import cn.superiormc.mythicprefixes.objects.effect.ObjectMMEffect;
import cn.superiormc.mythicprefixes.objects.effect.ObjectMMOEffect;
import cn.superiormc.mythicprefixes.utils.CommonUtil;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MythicPrefixesAPI {
    public static EffectStatus startEffect(ObjectPrefix prefix, Player player) {
        EffectStatus effectStatus = new EffectStatus();
        ConfigurationSection section = prefix.getConfig().getConfigurationSection("effects");
        if (section != null) {
            for (String tempVal1 : section.getKeys(false)) {
                ConfigurationSection tempVal3;
                if (tempVal1.equals("enabled") || (tempVal3 = section.getConfigurationSection(tempVal1)) == null) continue;
                AbstractEffect tempVal2 = null;
                switch (tempVal3.getString("type", "MythicLib")) {
                    case "MythicLib": {
                        if (!CommonUtil.checkPluginLoad("MythicLib")) break;
                        tempVal2 = new ObjectMMOEffect(prefix.getId() + tempVal1, player, tempVal3);
                        break;
                    }
                    case "MythicMobs": {
                        if (!CommonUtil.checkPluginLoad("MythicMobs")) break;
                        tempVal2 = new ObjectMMEffect(prefix.getId() + tempVal1, player, tempVal3);
                        break;
                    }
                    case "AuraSkills": {
                        if (!CommonUtil.checkPluginLoad("AuraSkills")) break;
                        tempVal2 = new ObjectAuraSkillsEffect(prefix.getId() + tempVal1, player, tempVal3);
                    }
                }
                if (tempVal2 == null) continue;
                if (tempVal2.getCondition().getAllBoolean(player)) {
                    tempVal2.addPlayerStat();
                    effectStatus.addAcvtiedEffects(tempVal2);
                    continue;
                }
                effectStatus.addNotActivedEffects(tempVal2);
            }
        }
        return effectStatus;
    }

    public static Collection<ObjectPrefix> getActivedPrefixes(Player player) {
        if (CacheManager.cacheManager == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not get cache object in plugin, please try restart the server.");
            return new TreeSet<ObjectPrefix>();
        }
        if (CacheManager.cacheManager.getPlayerCache(player) == null) {
            return new TreeSet<ObjectPrefix>();
        }
        return CacheManager.cacheManager.getPlayerCache(player).getActivePrefixes();
    }

    public static Collection<ObjectPrefix> getActivedPrefixesHasEffect(Player player) {
        HashSet<ObjectPrefix> prefixes = new HashSet<ObjectPrefix>();
        for (ObjectPrefix prefix : MythicPrefixesAPI.getActivedPrefixes(player)) {
            if (prefix.getEffectStatus(player).getActivedEffects().isEmpty()) continue;
            prefixes.add(prefix);
        }
        return prefixes;
    }

    public static int getMaxPrefixesAmount(Player player, String groupID) {
        ConfigurationSection conditionSection;
        ConfigurationSection section;
        if (groupID == null) {
            section = ConfigManager.configManager.getConfigurationSection("max-prefixes-amount.default");
            if (section == null && (section = ConfigManager.configManager.getConfigurationSection("max-prefixes-amount")) == null) {
                return 1;
            }
        } else {
            section = ConfigManager.configManager.getConfigurationSection("max-prefixes-amount." + groupID);
            if (section == null) {
                return Integer.MAX_VALUE;
            }
        }
        if ((conditionSection = ConfigManager.configManager.getConfigurationSection("max-prefixes-amount-conditions")) == null) {
            return section.getInt("default", 1);
        }
        Set groupNameSet = conditionSection.getKeys(false);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String groupName : groupNameSet) {
            ObjectCondition condition = new ObjectCondition(conditionSection.getConfigurationSection(groupName));
            if (section.getInt(groupName, 0) > 0 && condition.getAllBoolean(player)) {
                result.add(section.getInt(groupName));
                continue;
            }
            if (section.getInt("default") <= 0) continue;
            result.add(section.getInt("default", 1));
        }
        if (result.isEmpty()) {
            result.add(1);
        }
        return (Integer)Collections.max(result);
    }

    public static String getStatusPlaceholder(ObjectPrefix prefix, ObjectCache cache) {
        switch (prefix.getPrefixStatus(cache)) {
            case USING: {
                return TextUtil.parse(ConfigManager.configManager.getString("status-placeholder.using", new String[0]));
            }
            case CAN_USE: {
                return TextUtil.parse(ConfigManager.configManager.getString("status-placeholder.unlocked", new String[0]));
            }
            case MAX_LIMIT_REACHED: {
                return TextUtil.parse(ConfigManager.configManager.getString("status-placeholder.max-reached", new String[0]));
            }
            case CONDITION_NOT_MEET: {
                return TextUtil.parse(ConfigManager.configManager.getString("status-placeholder.locked", new String[0]));
            }
        }
        return "";
    }
}

