/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.commands;

import cn.superiormc.mythicprefixes.manager.CacheManager;
import cn.superiormc.mythicprefixes.manager.LanguageManager;
import cn.superiormc.mythicprefixes.objects.AbstractCommand;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SubViewUsingPrefix
extends AbstractCommand {
    public SubViewUsingPrefix() {
        this.id = "viewusingprefix";
        this.requiredPermission = "mythicprefixes." + this.id;
        this.onlyInGame = false;
        this.requiredArgLength = new Integer[]{1, 2};
    }

    @Override
    public void executeCommandInGame(String[] args, Player player) {
        Player whoWillAdd = args.length == 1 ? player : Bukkit.getPlayer((String)args[1]);
        if (whoWillAdd == null) {
            LanguageManager.languageManager.sendStringText(player, "error.player-not-found", "player", args[1]);
            return;
        }
        ObjectCache playerCache = CacheManager.cacheManager.getPlayerCache(whoWillAdd);
        if (playerCache.getActivePrefixes().isEmpty()) {
            LanguageManager.languageManager.sendStringText(player, "error.prefix-is-empty", "player", whoWillAdd.getName());
            return;
        }
        LanguageManager.languageManager.sendStringText(player, "view-prefix.head", "player", whoWillAdd.getName());
        for (ObjectPrefix prefix : playerCache.getActivePrefixes()) {
            LanguageManager.languageManager.sendStringText(player, "view-prefix.format", "player", whoWillAdd.getName(), "prefix", prefix.getDisplayValue(whoWillAdd));
        }
    }

    @Override
    public void executeCommandInConsole(String[] args) {
        if (args.length == 1) {
            LanguageManager.languageManager.sendStringText("error.args");
            return;
        }
        Player whoWillAdd = Bukkit.getPlayer((String)args[1]);
        if (whoWillAdd == null) {
            LanguageManager.languageManager.sendStringText("error.player-not-found", "player", args[1]);
            return;
        }
        ObjectCache playerCache = CacheManager.cacheManager.getPlayerCache(whoWillAdd);
        if (playerCache.getActivePrefixes().isEmpty()) {
            LanguageManager.languageManager.sendStringText("error.prefix-is-empty", "player", whoWillAdd.getName());
            return;
        }
        for (ObjectPrefix prefix : playerCache.getActivePrefixes()) {
            LanguageManager.languageManager.sendStringText("view-prefix.format", "player", whoWillAdd.getName(), "prefix", prefix.getDisplayValue(whoWillAdd));
        }
    }

    @Override
    public List<String> getTabResult(int length) {
        ArrayList<String> tempVal1 = new ArrayList<String>();
        switch (length) {
            case 2: {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tempVal1.add(player.getName());
                }
                break;
            }
        }
        return tempVal1;
    }
}

