/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.gui.form;

import cn.superiormc.mythicprefixes.gui.Filter;
import cn.superiormc.mythicprefixes.gui.FormGUI;
import cn.superiormc.mythicprefixes.manager.CacheManager;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.PrefixStatus;
import cn.superiormc.mythicprefixes.objects.buttons.AbstractButton;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;

public class FormChoosePrefixGUI
extends FormGUI {
    private final Map<ButtonComponent, AbstractButton> buttonCache = new HashMap<ButtonComponent, AbstractButton>();
    private ButtonComponent filterButtonCache;
    private Filter filter = Filter.ALL;

    public FormChoosePrefixGUI(Player owner) {
        super(owner);
        this.constructGUI();
    }

    @Override
    protected void constructGUI() {
        SimpleForm.Builder tempVal2 = SimpleForm.builder();
        ObjectCache cache = CacheManager.cacheManager.getPlayerCache(this.player);
        if (this.buttonCache.isEmpty()) {
            ButtonComponent tempVal1;
            for (ObjectPrefix prefix : ConfigManager.configManager.getPrefixesWithoutHide()) {
                PrefixStatus status = prefix.getPrefixStatus(cache);
                if (this.filter != Filter.ALL && (this.filter != Filter.USING || status != PrefixStatus.USING) && (this.filter != Filter.CAN_USE || status != PrefixStatus.CAN_USE) || !prefix.shouldHideInGUI(this.player)) continue;
                tempVal1 = prefix.parseToBedrockButton(cache);
                if (tempVal1 != null) {
                    tempVal2.button(tempVal1);
                }
                this.buttonCache.put(tempVal1, prefix);
            }
            Iterator<Comparable<ObjectPrefix>> iterator = ConfigManager.configManager.getButtons().keySet().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                AbstractButton button = ConfigManager.configManager.getButtons().get(slot);
                if (button == null) continue;
                tempVal1 = button.parseToBedrockButton(cache);
                if (tempVal1 != null) {
                    tempVal2.button(tempVal1);
                }
                this.buttonCache.put(tempVal1, button);
            }
        }
        tempVal2.title(TextUtil.parse(ConfigManager.configManager.getString("choose-prefix-gui.title", "Tag GUI")));
        ConfigurationSection filterSection = ConfigManager.configManager.getConfigurationSection("choose-prefix-gui.filter-item");
        if (filterSection != null) {
            // empty if block
        }
        tempVal2.validResultHandler(response -> {
            if (this.filterButtonCache == null || !response.clickedButton().equals((Object)this.filterButtonCache)) {
                this.buttonCache.get(response.clickedButton()).clickEvent(ClickType.LEFT, this.player);
            }
        });
        this.form = tempVal2.build();
    }
}

