/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.gui.inv;

import cn.superiormc.mythicprefixes.MythicPrefixes;
import cn.superiormc.mythicprefixes.gui.Filter;
import cn.superiormc.mythicprefixes.gui.InvGUI;
import cn.superiormc.mythicprefixes.gui.form.FormChoosePrefixGUI;
import cn.superiormc.mythicprefixes.manager.CacheManager;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.PrefixStatus;
import cn.superiormc.mythicprefixes.objects.buttons.AbstractButton;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import cn.superiormc.mythicprefixes.utils.CommonUtil;
import cn.superiormc.mythicprefixes.utils.ItemUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ChoosePrefixGUI
extends InvGUI {
    private final Map<Integer, AbstractButton> prefixCache = new HashMap<Integer, AbstractButton>();
    private final Map<Integer, AbstractButton> buttonCache = new HashMap<Integer, AbstractButton>();
    private final List<Integer> slotCache;
    private Filter filter = Filter.ALL;
    private int needPages = 1;
    private int nowPage = 1;
    private int nextPageSlot = -1;
    private int previousPageSlot = -1;
    private int filterSlot = -1;
    private final String selectedGroup;

    private ChoosePrefixGUI(Player player, String group) {
        super(player);
        this.selectedGroup = group;
        this.slotCache = ConfigManager.configManager.getIntList("choose-prefix-gui.prefix-item-slot");
        this.constructGUI();
    }

    @Override
    protected void constructGUI() {
        int i = 0;
        ObjectCache cache = CacheManager.cacheManager.getPlayerCache(this.player);
        if (this.prefixCache.isEmpty()) {
            for (ObjectPrefix objectPrefix : ConfigManager.configManager.getPrefixesWithoutHide()) {
                if (!this.selectedGroup.equals("all") && !objectPrefix.getGroups().contains(this.selectedGroup)) continue;
                PrefixStatus status = objectPrefix.getPrefixStatus(cache);
                if (this.filter != Filter.ALL && (this.filter != Filter.USING || status != PrefixStatus.USING) && (this.filter != Filter.CAN_USE || status != PrefixStatus.CAN_USE) || !objectPrefix.shouldHideInGUI(this.player)) continue;
                this.prefixCache.put(i, objectPrefix);
                ++i;
            }
            if (this.prefixCache.size() >= this.slotCache.size()) {
                this.needPages = (int)Math.ceil((double)this.prefixCache.size() / (double)this.slotCache.size());
            }
        }
        if (Objects.isNull(this.inv)) {
            int size = ConfigManager.configManager.getInt("choose-prefix-gui.size", 54);
            String string = ConfigManager.configManager.getString("choose-prefix-gui.title", "Tag GUI");
            this.inv = MythicPrefixes.methodUtil.createNewInv(this.player, size, string);
        }
        for (int c = 0; c < this.slotCache.size(); ++c) {
            AbstractButton abstractButton = this.prefixCache.get((this.nowPage - 1) * this.slotCache.size() + c);
            if (abstractButton == null) {
                this.inv.clear(this.slotCache.get(c).intValue());
                continue;
            }
            this.inv.setItem(this.slotCache.get(c).intValue(), abstractButton.getDisplayItem(this.player));
        }
        if (this.buttonCache.isEmpty()) {
            for (int n : ConfigManager.configManager.getButtons().keySet()) {
                AbstractButton button = ConfigManager.configManager.getButtons().get(n);
                if (button == null) continue;
                this.buttonCache.put(n, button);
                this.inv.setItem(n, button.getDisplayItem(this.player));
            }
        }
        ConfigurationSection nextPageSection = ConfigManager.configManager.getConfigurationSection("choose-prefix-gui.next-page-item");
        if (this.nowPage < this.needPages && nextPageSection != null) {
            ItemStack itemStack = ItemUtil.buildItemStack(this.player, nextPageSection, "max", String.valueOf(this.needPages), "now", String.valueOf(this.nowPage));
            this.nextPageSlot = nextPageSection.getInt("slot", 52);
            if (this.nextPageSlot >= 0) {
                this.inv.setItem(this.nextPageSlot, itemStack);
            }
        } else if (this.nextPageSlot >= 0 && this.nextPageSlot < 54) {
            this.inv.clear(this.nextPageSlot);
        }
        ConfigurationSection configurationSection = ConfigManager.configManager.getConfigurationSection("choose-prefix-gui.previous-page-item");
        if (this.nowPage > 1 && configurationSection != null) {
            ItemStack previousPageItem = ItemUtil.buildItemStack(this.player, configurationSection, "max", String.valueOf(this.needPages), "now", String.valueOf(this.nowPage));
            this.previousPageSlot = configurationSection.getInt("slot", 46);
            if (this.previousPageSlot >= 0) {
                this.inv.setItem(this.previousPageSlot, previousPageItem);
            }
        } else if (this.previousPageSlot >= 0 && this.previousPageSlot < 54) {
            this.inv.clear(this.previousPageSlot);
        }
        ConfigurationSection filterSection = ConfigManager.configManager.getConfigurationSection("choose-prefix-gui.filter-item");
        if (filterSection != null) {
            // empty if block
        }
    }

    @Override
    public boolean clickEventHandle(Inventory inventory, ClickType type, int slot) {
        if (slot == this.nextPageSlot) {
            if (this.nowPage < this.needPages) {
                ++this.nowPage;
            }
        } else if (slot == this.previousPageSlot) {
            if (this.nowPage > 0) {
                --this.nowPage;
            }
        } else {
            AbstractButton prefix;
            if (slot == this.filterSlot) {
                // empty if block
            }
            if ((prefix = this.prefixCache.get((this.nowPage - 1) * this.slotCache.size() + this.slotCache.indexOf(slot))) != null) {
                prefix.clickEvent(type, this.player);
            } else {
                AbstractButton button = this.buttonCache.get(slot);
                if (button != null) {
                    button.clickEvent(type, this.player);
                }
            }
        }
        this.constructGUI();
        return true;
    }

    public static void openGUI(Player player, String group) {
        if (CommonUtil.isBedrockPlayer(player)) {
            FormChoosePrefixGUI gui = new FormChoosePrefixGUI(player);
            gui.openGUI();
            return;
        }
        ChoosePrefixGUI gui = new ChoosePrefixGUI(player, group);
        gui.openGUI();
    }
}

