/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.libreforge;

import cn.superiormc.mythicprefixes.MythicPrefixes;
import cn.superiormc.mythicprefixes.api.MythicPrefixesAPI;
import cn.superiormc.mythicprefixes.libreforge.LibreforgeEffect;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.Configs;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.libreforge.Dispatcher;
import com.willfp.libreforge.HolderProvider;
import com.willfp.libreforge.HolderProviderKt;
import com.willfp.libreforge.ProvidedHolder;
import com.willfp.libreforge.SimpleProvidedHolder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LibreforgeEffects {
    public static LibreforgeEffects libreforgeEffects;
    private Config config;
    private Map<String, LibreforgeEffect> libreforgeEffectMap;

    public LibreforgeEffects() {
        libreforgeEffects = this;
        this.cleanMap();
        this.initLibreforgeHook();
    }

    public void cleanMap() {
        this.libreforgeEffectMap = new HashMap<String, LibreforgeEffect>();
    }

    private void initLibreforgeHook() {
        HolderProviderKt.registerHolderProvider((HolderProvider)new HolderProvider(){

            @NotNull
            public Collection<ProvidedHolder> provide(@NotNull Dispatcher<?> dispatcher) {
                HashSet<ProvidedHolder> tempVal1 = new HashSet<ProvidedHolder>();
                if (dispatcher.getDispatcher() instanceof Player) {
                    Player player = (Player)dispatcher.getDispatcher();
                    for (ObjectPrefix tempVal2 : MythicPrefixesAPI.getActivedPrefixes(player)) {
                        LibreforgeEffect tempVal3 = (LibreforgeEffect)LibreforgeEffects.this.libreforgeEffectMap.get(tempVal2.getId());
                        if (tempVal3 == null) continue;
                        tempVal1.add((ProvidedHolder)new SimpleProvidedHolder(tempVal3.getHolder()));
                    }
                }
                return tempVal1;
            }
        });
    }

    public void registerLibreforgeEffect(String id) {
        File file = new File(MythicPrefixes.instance.getDataFolder(), "config.yml");
        if (!file.exists()) {
            return;
        }
        this.config = Configs.fromFile((File)file, (ConfigType)ConfigType.YAML);
        for (Config tempVal1 : this.config.getSubsections("libreforge-effects")) {
            String tempVal2 = tempVal1.getString("id");
            if (!id.equals(tempVal2)) continue;
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fSuccessfully added " + id + " effects to libreforge!");
            this.libreforgeEffectMap.put(id, new LibreforgeEffect(id, tempVal1));
            break;
        }
    }
}

