/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.manager;

import cn.superiormc.mythicprefixes.objects.actions.AbstractRunAction;
import cn.superiormc.mythicprefixes.objects.actions.ActionAddPrefix;
import cn.superiormc.mythicprefixes.objects.actions.ActionAnnouncement;
import cn.superiormc.mythicprefixes.objects.actions.ActionAny;
import cn.superiormc.mythicprefixes.objects.actions.ActionChance;
import cn.superiormc.mythicprefixes.objects.actions.ActionClose;
import cn.superiormc.mythicprefixes.objects.actions.ActionConditional;
import cn.superiormc.mythicprefixes.objects.actions.ActionConsoleCommand;
import cn.superiormc.mythicprefixes.objects.actions.ActionDelay;
import cn.superiormc.mythicprefixes.objects.actions.ActionEffect;
import cn.superiormc.mythicprefixes.objects.actions.ActionEntitySpawn;
import cn.superiormc.mythicprefixes.objects.actions.ActionMessage;
import cn.superiormc.mythicprefixes.objects.actions.ActionOPCommand;
import cn.superiormc.mythicprefixes.objects.actions.ActionParticle;
import cn.superiormc.mythicprefixes.objects.actions.ActionPlayerCommand;
import cn.superiormc.mythicprefixes.objects.actions.ActionRemoveAll;
import cn.superiormc.mythicprefixes.objects.actions.ActionRemovePrefix;
import cn.superiormc.mythicprefixes.objects.actions.ActionSound;
import cn.superiormc.mythicprefixes.objects.actions.ActionTeleport;
import cn.superiormc.mythicprefixes.objects.actions.ActionTitle;
import cn.superiormc.mythicprefixes.objects.actions.ObjectSingleAction;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class ActionManager {
    public static ActionManager actionManager;
    private Map<String, AbstractRunAction> actions;

    public ActionManager() {
        actionManager = this;
        this.initActions();
    }

    private void initActions() {
        this.actions = new HashMap<String, AbstractRunAction>();
        this.registerNewAction("message", new ActionMessage());
        this.registerNewAction("title", new ActionTitle());
        this.registerNewAction("particle", new ActionParticle());
        this.registerNewAction("sound", new ActionSound());
        this.registerNewAction("announcement", new ActionAnnouncement());
        this.registerNewAction("effect", new ActionEffect());
        this.registerNewAction("console_command", new ActionConsoleCommand());
        this.registerNewAction("op_command", new ActionOPCommand());
        this.registerNewAction("player_command", new ActionPlayerCommand());
        this.registerNewAction("teleport", new ActionTeleport());
        this.registerNewAction("entity_spawn", new ActionEntitySpawn());
        this.registerNewAction("close", new ActionClose());
        this.registerNewAction("chance", new ActionChance());
        this.registerNewAction("delay", new ActionDelay());
        this.registerNewAction("any", new ActionAny());
        this.registerNewAction("add_prefix", new ActionAddPrefix());
        this.registerNewAction("remove_prefix", new ActionRemovePrefix());
        this.registerNewAction("removeall", new ActionRemoveAll());
        this.registerNewAction("conditional", new ActionConditional());
    }

    public void registerNewAction(String actionID, AbstractRunAction action) {
        if (!this.actions.containsKey(actionID)) {
            this.actions.put(actionID, action);
        }
    }

    public void doAction(ObjectSingleAction action, Player player) {
        for (AbstractRunAction runAction : this.actions.values()) {
            String type = action.getString("type");
            if (!runAction.getType().equals(type)) continue;
            runAction.runAction(action, player);
        }
    }
}

