/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.manager;

import cn.superiormc.mythicprefixes.database.SQLDatabase;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.effect.ObjectAuraSkillsEffect;
import cn.superiormc.mythicprefixes.utils.CommonUtil;
import cn.superiormc.mythicprefixes.utils.SchedulerUtil;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class CacheManager {
    public static CacheManager cacheManager;
    private final Map<Player, ObjectCache> playerCacheMap = new HashMap<Player, ObjectCache>();
    private final Map<Player, SchedulerUtil> delayCacheMap = new HashMap<Player, SchedulerUtil>();
    private boolean isStoppingServer;

    public CacheManager() {
        cacheManager = this;
        this.isStoppingServer = false;
        if (ConfigManager.configManager.getBoolean("database.enabled")) {
            SQLDatabase.closeSQL();
            SQLDatabase.initSQL();
        }
    }

    public void addPlayerCache(Player player) {
        if (this.delayCacheMap.containsKey(player)) {
            this.delayCacheMap.get(player).cancel();
        }
        if (!this.playerCacheMap.containsKey(player)) {
            this.playerCacheMap.put(player, new ObjectCache(player));
        }
    }

    public void loadPlayerCache(Player player) {
        ObjectCache cache = this.getPlayerCache(player);
        cache.runAllPrefixEndActions();
        cache.removeAllActivePrefix(false);
        if (CommonUtil.checkPluginLoad("AuraSkills")) {
            ObjectAuraSkillsEffect.removePlayerStat(player, 1);
        }
        cache.initPlayerCache();
    }

    public void removePlayerCache(final Player player) {
        if (ConfigManager.configManager.getLong("cache.remove-delay", -1L) > 0L) {
            SchedulerUtil tempVal1 = SchedulerUtil.runTaskLater((Runnable)new BukkitRunnable(){

                public void run() {
                    ((ObjectCache)CacheManager.this.playerCacheMap.get(player)).removeAllActivePrefix(false);
                    CacheManager.this.playerCacheMap.remove(player);
                    CacheManager.this.delayCacheMap.remove(player);
                }
            }, ConfigManager.configManager.getLong("cache.remove-delay", 60L));
            this.delayCacheMap.put(player, tempVal1);
        } else {
            this.playerCacheMap.get(player).removeAllActivePrefix(false);
            this.playerCacheMap.remove(player);
        }
    }

    public void savePlayerCacheOnExit(Player player) {
        if (this.playerCacheMap.get(player) == null) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cError: Can not save player data: " + player.getName() + "!");
            return;
        }
        this.playerCacheMap.get(player).shutPlayerCache(true);
    }

    public void savePlayerCacheOnDisable(Player player) {
        if (this.playerCacheMap.get(player) == null) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cError: Can not save player data: " + player.getName() + "!");
            return;
        }
        this.playerCacheMap.get(player).shutPlayerCacheOnDisable();
    }

    public void setStoppingServer() {
        this.isStoppingServer = true;
    }

    public ObjectCache getPlayerCache(Player player) {
        ObjectCache playerCache = this.playerCacheMap.get(player);
        if (playerCache == null) {
            cacheManager.addPlayerCache(player);
            playerCache = cacheManager.getPlayerCache(player);
        }
        return playerCache;
    }
}

