/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.manager;

import cn.superiormc.mythicprefixes.objects.conditions.AbstractCheckCondition;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionAny;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionBiome;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionEffectedPrefixAmount;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionEquippedPrefix;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionEquippedPrefixAmount;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionNot;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionPermission;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionPlaceholder;
import cn.superiormc.mythicprefixes.objects.conditions.ConditionWorld;
import cn.superiormc.mythicprefixes.objects.conditions.ObjectSingleCondition;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class ConditionManager {
    public static ConditionManager conditionManager;
    private Map<String, AbstractCheckCondition> conditions;

    public ConditionManager() {
        conditionManager = this;
        this.initConditions();
    }

    private void initConditions() {
        this.conditions = new HashMap<String, AbstractCheckCondition>();
        this.registerNewCondition("biome", new ConditionBiome());
        this.registerNewCondition("permission", new ConditionPermission());
        this.registerNewCondition("placeholder", new ConditionPlaceholder());
        this.registerNewCondition("world", new ConditionWorld());
        this.registerNewCondition("any", new ConditionAny());
        this.registerNewCondition("not", new ConditionNot());
        this.registerNewCondition("equipped_prefix", new ConditionEquippedPrefix());
        this.registerNewCondition("equipped_prefix_amount", new ConditionEquippedPrefixAmount());
        this.registerNewCondition("effected_prefix_amount", new ConditionEffectedPrefixAmount());
    }

    public void registerNewCondition(String actionID, AbstractCheckCondition condition) {
        if (!this.conditions.containsKey(actionID)) {
            this.conditions.put(actionID, condition);
        }
    }

    public boolean checkBoolean(ObjectSingleCondition condition, Player player) {
        for (AbstractCheckCondition checkCondition : this.conditions.values()) {
            String type = condition.getString("type");
            if (!checkCondition.getType().equals(type) || checkCondition.checkCondition(condition, player)) continue;
            return false;
        }
        return true;
    }
}

