/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.manager;

import cn.superiormc.mythicprefixes.MythicPrefixes;
import cn.superiormc.mythicprefixes.libreforge.LibreforgeEffects;
import cn.superiormc.mythicprefixes.objects.ObjectDisplayPlaceholder;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectButton;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    public static ConfigManager configManager;
    public FileConfiguration config;
    public Map<String, ObjectPrefix> prefixConfigs = new TreeMap<String, ObjectPrefix>();
    public Collection<ObjectPrefix> prefixCaches = new TreeSet<ObjectPrefix>();
    public Map<Integer, ObjectButton> buttonConfigs = new TreeMap<Integer, ObjectButton>();
    public Map<String, ObjectDisplayPlaceholder> placeholderConfigs = new HashMap<String, ObjectDisplayPlaceholder>();
    private int useEffectPrefixAmount = 0;

    public ConfigManager() {
        configManager = this;
        MythicPrefixes.instance.saveDefaultConfig();
        this.config = MythicPrefixes.instance.getConfig();
        this.initLibreforgeHook();
        this.initPrefixesConfigs();
        this.initDisplayPlaceholderConfigs();
        this.initButtonConfigs();
    }

    private void initLibreforgeHook() {
        if (configManager.getBoolean("libreforge-hook")) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fHooking into libreforge...");
            try {
                if (LibreforgeEffects.libreforgeEffects == null) {
                    new LibreforgeEffects();
                } else {
                    LibreforgeEffects.libreforgeEffects.cleanMap();
                }
            }
            catch (Exception ignored) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cFailed to hook into.");
            }
        }
    }

    private void initDisplayPlaceholderConfigs() {
        File[] files;
        File dir = new File(MythicPrefixes.instance.getDataFolder(), "display_placeholders");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            this.placeholderConfigs.put(substring, new ObjectDisplayPlaceholder(substring, (ConfigurationSection)YamlConfiguration.loadConfiguration((File)file)));
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fLoaded display placeholder: " + fileName + "!");
        }
        if (this.placeholderConfigs.isEmpty()) {
            ConfigurationSection tempVal1 = this.config.getConfigurationSection("display-placeholder");
            if (tempVal1 == null) {
                return;
            }
            for (String id : tempVal1.getKeys(false)) {
                this.placeholderConfigs.put(id, new ObjectDisplayPlaceholder(id, tempVal1.getConfigurationSection(id)));
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fLoaded display placeholder: " + id + "!");
            }
        }
    }

    private void initButtonConfigs() {
        ConfigurationSection tempVal1 = this.config.getConfigurationSection("choose-prefix-gui.custom-item");
        if (tempVal1 == null) {
            return;
        }
        for (String id : tempVal1.getKeys(false)) {
            this.buttonConfigs.put(Integer.parseInt(id), new ObjectButton(tempVal1.getConfigurationSection(id)));
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fLoaded custom button: " + id + "!");
        }
    }

    private void initPrefixesConfigs() {
        File[] files;
        File dir = new File(MythicPrefixes.instance.getDataFolder(), "prefixes");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            ObjectPrefix prefix = new ObjectPrefix(substring, YamlConfiguration.loadConfiguration((File)file));
            if (this.useEffectPrefixAmount < 3) {
                prefix.initEffects();
            } else if (prefix.enabledEffect()) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cError: Free version can only create up to 3 prefixes that enable effect, skipping init effect for prefix: " + substring + "!");
            }
            ++this.useEffectPrefixAmount;
            this.prefixConfigs.put(substring, prefix);
            this.prefixCaches.add(prefix);
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fLoaded prefix: " + fileName + "!");
        }
    }

    public ObjectPrefix getPrefix(String id) {
        ObjectPrefix prefix = this.prefixConfigs.get(id);
        if (prefix == null) {
            return this.prefixConfigs.get(id.replace('-', '_'));
        }
        return prefix;
    }

    public ObjectDisplayPlaceholder getDisplayPlaceholder(String id) {
        ObjectDisplayPlaceholder placeholder = this.placeholderConfigs.get(id);
        if (placeholder == null) {
            return this.placeholderConfigs.get(id.replace('-', '_'));
        }
        return placeholder;
    }

    public Collection<ObjectPrefix> getPrefixesWithoutHide() {
        TreeSet<ObjectPrefix> resultPrefixes = new TreeSet<ObjectPrefix>();
        for (ObjectPrefix prefix : this.prefixCaches) {
            if (!prefix.getDisplayInGUI()) continue;
            resultPrefixes.add(prefix);
        }
        return resultPrefixes;
    }

    public Collection<ObjectPrefix> getPrefixes() {
        return this.prefixCaches;
    }

    public Map<Integer, ObjectButton> getButtons() {
        return this.buttonConfigs;
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path, false);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public List<Integer> getIntList(String path) {
        return this.config.getIntegerList(path);
    }

    public long getLong(String path, long defaultValue) {
        return this.config.getLong(path, defaultValue);
    }

    public String getString(String path, String ... args) {
        String s = this.config.getString(path);
        if (s == null) {
            s = args[0];
        }
        for (int i = 1; i < args.length; i += 2) {
            String var = "{" + args[i] + "}";
            s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
        }
        return s.replace("{plugin_folder}", String.valueOf(MythicPrefixes.instance.getDataFolder()));
    }

    public ConfigurationSection getConfigurationSection(String path) {
        if (!this.config.contains(path)) {
            return null;
        }
        return this.config.getConfigurationSection(path);
    }

    public FileConfiguration getSection() {
        return this.config;
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }
}

