/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.manager;

import cn.superiormc.mythicprefixes.manager.CacheManager;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.utils.SchedulerUtil;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TaskManager {
    public static TaskManager taskManager;
    private SchedulerUtil saveTask;
    private SchedulerUtil conditionCheckTask;

    public TaskManager() {
        taskManager = this;
        if (ConfigManager.configManager.getBoolean("auto-save.enabled")) {
            this.initSaveTasks();
        }
        this.initConditionCheckTasks();
    }

    public void initSaveTasks() {
        this.saveTask = SchedulerUtil.runTaskTimer(() -> {
            if (!ConfigManager.configManager.getBoolean("auto-save.hide-message")) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fAuto saving data...");
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fIf this lead to server TPS drop, you should consider disable auto save feature at config.yml!");
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (CacheManager.cacheManager.getPlayerCache(player) == null) continue;
                CacheManager.cacheManager.getPlayerCache(player).shutPlayerCache(false);
            }
        }, 180L, ConfigManager.configManager.config.getLong("auto-save.period-tick", 600L));
    }

    public void initConditionCheckTasks() {
        this.conditionCheckTask = SchedulerUtil.runTaskTimer(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (CacheManager.cacheManager.getPlayerCache(player) == null) continue;
                CacheManager.cacheManager.getPlayerCache(player).checkCondition();
            }
        }, 20L, 20L);
    }

    public void cancelTask() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        if (this.conditionCheckTask != null) {
            this.conditionCheckTask.cancel();
        }
    }
}

