/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.objects;

import cn.superiormc.mythicprefixes.api.MythicPrefixesAPI;
import cn.superiormc.mythicprefixes.database.SQLDatabase;
import cn.superiormc.mythicprefixes.database.YamlDatabase;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.objects.PrefixStatus;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import cn.superiormc.mythicprefixes.utils.SchedulerUtil;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ObjectCache {
    private final Player player;
    private final Collection<ObjectPrefix> prefixCaches = new TreeSet<ObjectPrefix>();
    private final Map<ObjectPrefix, SchedulerUtil> taskCache = new HashMap<ObjectPrefix, SchedulerUtil>();
    private boolean finishLoad;

    public ObjectCache(Player player) {
        this.player = player;
    }

    public void initPlayerCache() {
        SchedulerUtil.runTaskAsynchronously(() -> {
            if (ConfigManager.configManager.getBoolean("database.enabled")) {
                SQLDatabase.checkData(this);
            } else {
                YamlDatabase.checkData(this);
            }
        });
    }

    public void shutPlayerCache(boolean quitServer) {
        SchedulerUtil.runTaskAsynchronously(() -> {
            if (ConfigManager.configManager.getBoolean("database.enabled")) {
                SQLDatabase.updateData(this, quitServer);
            } else {
                YamlDatabase.updateData(this, quitServer);
            }
        });
    }

    public void shutPlayerCacheOnDisable() {
        if (ConfigManager.configManager.getBoolean("database.enabled")) {
            SQLDatabase.updateDataNoAsync(this);
        } else {
            YamlDatabase.updateData(this, true);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setActivePrefixes(String values) {
        for (String prefixKey : values.split(";;")) {
            ObjectPrefix tempVal2 = ConfigManager.configManager.getPrefix(prefixKey);
            if (tempVal2 == null) continue;
            SchedulerUtil.runSync(() -> this.addActivePrefix(tempVal2));
        }
    }

    public void addActivePrefix(ObjectPrefix prefix) {
        if (prefix.getPrefixStatus(this) != PrefixStatus.CAN_USE) {
            return;
        }
        prefix.runStartAction(this);
        this.prefixCaches.add(prefix);
        if (ConfigManager.configManager.getBoolean("debug")) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fEnabled prefix " + String.valueOf(prefix) + " for player " + this.player.getName() + "!");
        }
    }

    public void removeActivePrefix(ObjectPrefix prefix, boolean runEndAction) {
        if (runEndAction) {
            prefix.runEndAction(this);
        }
        this.prefixCaches.remove(prefix);
        if (ConfigManager.configManager.getBoolean("debug")) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fDisabled prefix " + String.valueOf(prefix) + " for player " + this.player.getName() + "!");
        }
    }

    public void removeAllActivePrefix(boolean runEndAction) {
        for (ObjectPrefix prefix : MythicPrefixesAPI.getActivedPrefixes(this.player)) {
            this.removeActivePrefix(prefix, runEndAction);
        }
    }

    public void runAllPrefixEndActions() {
        for (ObjectPrefix prefix : MythicPrefixesAPI.getActivedPrefixes(this.player)) {
            prefix.runEndAction(this);
        }
    }

    public Collection<ObjectPrefix> getActivePrefixes() {
        return new TreeSet<ObjectPrefix>(this.prefixCaches);
    }

    public String getActivePrefixesID() {
        int i = 0;
        StringBuilder tempVal2 = new StringBuilder();
        for (ObjectPrefix tempVal1 : this.getActivePrefixes()) {
            if (i > 0) {
                tempVal2.append(";;");
            }
            tempVal2.append(tempVal1.getId());
            ++i;
        }
        return tempVal2.toString();
    }

    public void checkCondition() {
        if (!this.isFinishLoad()) {
            return;
        }
        for (ObjectPrefix prefix : MythicPrefixesAPI.getActivedPrefixes(this.player)) {
            if (!prefix.isConditionNotMeet(this)) continue;
            this.removeActivePrefix(prefix, true);
        }
    }

    public void setAsFinished() {
        this.finishLoad = true;
    }

    public boolean isFinishLoad() {
        if (!ConfigManager.configManager.getBoolean("cache.bypass-condition-when-loading")) {
            return true;
        }
        return this.finishLoad;
    }

    public void addCircleTask(ObjectPrefix prefix, SchedulerUtil schedulerUtil) {
        this.taskCache.put(prefix, schedulerUtil);
    }

    public void cancelCircleTask(ObjectPrefix prefix) {
        SchedulerUtil schedulerUtil = this.taskCache.get(prefix);
        if (schedulerUtil != null) {
            schedulerUtil.cancel();
        }
        this.taskCache.remove(prefix);
    }
}

