/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.objects;

import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.PrefixStatus;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.bukkit.configuration.ConfigurationSection;

public class ObjectDisplayPlaceholder {
    private final String id;
    private final boolean alwaysDisplayDefaultPrefix;
    private final String startSymbol;
    private final String endSymbol;
    private final String splitSymbol;
    private List<String> prefixes;
    private final List<String> groups;
    private final int displayAmount;
    private final String empty;
    private final String mode;
    private final boolean parseColor;
    public Collection<ObjectPrefix> defaultPrefixCaches = new TreeSet<ObjectPrefix>();
    public static Collection<String> groupNames = new ArrayList<String>();

    public ObjectDisplayPlaceholder(String id, ConfigurationSection section) {
        this.id = id;
        this.alwaysDisplayDefaultPrefix = section.getBoolean("always-display-default-prefixes", false);
        this.startSymbol = section.getString("start-symbol");
        this.endSymbol = section.getString("end-symbol");
        this.splitSymbol = section.getString("split-symbol");
        this.prefixes = section.getStringList("display-prefixes.prefixes");
        if (this.prefixes.isEmpty()) {
            this.prefixes = section.getStringList("black-prefixes");
        }
        this.groups = section.getStringList("display-prefixes.groups");
        this.mode = section.getString("display-prefixes.mode", "BLACK");
        this.displayAmount = section.getInt("display-amount", -1);
        this.empty = section.getString("empty-display", null);
        this.parseColor = section.getBoolean("parse-color", true);
        for (String prefix : section.getStringList("default-prefixes")) {
            ObjectPrefix objectPrefix = ConfigManager.configManager.getPrefix(prefix);
            if (objectPrefix == null) continue;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getNoPrefixDisplayText(ObjectCache cache, int no) {
        Collection<ObjectPrefix> tempVal1 = cache.getActivePrefixes();
        if (tempVal1.size() > no) {
            return "";
        }
        int index = 1;
        for (ObjectPrefix prefix : tempVal1) {
            if (index == no) {
                if (this.parseColor) {
                    return TextUtil.parse(prefix.getDisplayValue(cache.getPlayer()));
                }
                return prefix.getDisplayValue(cache.getPlayer());
            }
            ++index;
        }
        return "";
    }

    public String getDisplayText(ObjectCache cache) {
        return this.getDisplayText(cache, null);
    }

    public String getDisplayText(ObjectCache cache, ObjectPrefix prefix) {
        if (cache == null) {
            return "ERROR: Cache not load";
        }
        StringBuilder tempVal1 = new StringBuilder(this.startSymbol);
        int tempVal4 = 0;
        TreeSet<ObjectPrefix> tempVal5 = new TreeSet<ObjectPrefix>();
        if (prefix != null && !cache.getActivePrefixes().contains(prefix)) {
            tempVal5.add(prefix);
            ++tempVal4;
        }
        for (ObjectPrefix tempVal3 : cache.getActivePrefixes()) {
            if (this.displayAmount > 0 && tempVal4 >= this.displayAmount) continue;
            if (!this.mode.equals("BLACK")) {
                // empty if block
            }
            if (!this.prefixes.isEmpty() && this.prefixes.contains(tempVal3.getId()) || !tempVal3.getGroups().isEmpty() && !this.groups.isEmpty() && new HashSet<String>(tempVal3.getGroups()).containsAll(this.groups)) continue;
            tempVal5.add(tempVal3);
            ++tempVal4;
        }
        if (tempVal5.isEmpty() || this.alwaysDisplayDefaultPrefix) {
            for (ObjectPrefix defaultPrefix : this.defaultPrefixCaches) {
                if (!defaultPrefix.getPrefixStatus(cache).equals((Object)PrefixStatus.CAN_USE)) continue;
                tempVal5.add(defaultPrefix);
                ++tempVal4;
                break;
            }
        }
        for (ObjectPrefix tempVal3 : tempVal5) {
            if (!tempVal1.toString().equals(this.startSymbol)) {
                tempVal1.append(this.splitSymbol);
            }
            tempVal1.append(tempVal3.getDisplayValue(cache.getPlayer()));
        }
        if (tempVal4 == 0 && this.empty != null) {
            return this.empty;
        }
        tempVal1.append(this.endSymbol);
        if (this.parseColor) {
            return TextUtil.parse(tempVal1.toString());
        }
        return tempVal1.toString();
    }
}

