/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.objects.buttons;

import cn.superiormc.mythicprefixes.api.MythicPrefixesAPI;
import cn.superiormc.mythicprefixes.manager.ErrorManager;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.ObjectCondition;
import cn.superiormc.mythicprefixes.objects.buttons.ButtonType;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import cn.superiormc.mythicprefixes.utils.CommonUtil;
import cn.superiormc.mythicprefixes.utils.ItemUtil;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.util.FormImage;

public abstract class AbstractButton {
    protected ConfigurationSection config;
    protected ObjectCondition condition;
    protected ButtonType type;

    public AbstractButton(ConfigurationSection config) {
        if (config == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not found config for button, there is something wrong in your menu configs!");
            return;
        }
        this.config = config;
    }

    public AbstractButton() {
    }

    public ItemStack getDisplayItem(Player player) {
        return new ItemStack(Material.STONE);
    }

    public void clickEvent(ClickType type, Player player) {
    }

    public ButtonType getType() {
        return this.type;
    }

    public ConfigurationSection getConfig() {
        return this.config;
    }

    public ButtonComponent parseToBedrockButton(ObjectCache cache) {
        Player player = cache.getPlayer();
        String icon = this.config.getString("bedrock.icon", this.config.getString("bedrock-icon"));
        if (this.config.getBoolean("bedrock.hide", false)) {
            return null;
        }
        Object tempVal3 = TextUtil.parse(ItemUtil.getItemNameWithoutVanilla(this.getDisplayItem(player)), player);
        String tempVal4 = this.config.getString("bedrock.extra-line");
        if (tempVal4 != null && !tempVal4.isEmpty()) {
            tempVal3 = this instanceof ObjectPrefix ? CommonUtil.modifyString((String)tempVal3 + "\n" + TextUtil.parse(tempVal4, player), "status", MythicPrefixesAPI.getStatusPlaceholder((ObjectPrefix)this, cache)) : (String)tempVal3 + "\n" + TextUtil.parse(tempVal4, player);
        }
        ButtonComponent tempVal1 = null;
        if (icon != null && icon.split(";;").length == 2) {
            String type = icon.split(";;")[0].toLowerCase();
            if (type.equals("url")) {
                tempVal1 = ButtonComponent.of((String)tempVal3, (FormImage.Type)FormImage.Type.URL, (String)icon.split(";;")[1]);
            } else if (type.equals("path")) {
                tempVal1 = ButtonComponent.of((String)tempVal3, (FormImage.Type)FormImage.Type.PATH, (String)icon.split(";;")[1]);
            }
        } else {
            tempVal1 = ButtonComponent.of((String)tempVal3);
        }
        return tempVal1;
    }
}

