/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.objects.buttons;

import cn.superiormc.mythicprefixes.objects.ObjectAction;
import cn.superiormc.mythicprefixes.objects.ObjectCondition;
import cn.superiormc.mythicprefixes.objects.buttons.AbstractButton;
import cn.superiormc.mythicprefixes.objects.buttons.ButtonType;
import cn.superiormc.mythicprefixes.utils.ItemUtil;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ObjectButton
extends AbstractButton {
    private ObjectAction action;

    public ObjectButton(ConfigurationSection config) {
        super(config);
        this.type = ButtonType.COMMON;
        this.initButton();
    }

    private void initButton() {
        this.action = new ObjectAction(this.config.getConfigurationSection("actions"));
        this.condition = new ObjectCondition(this.config.getConfigurationSection("conditions"));
    }

    @Override
    public void clickEvent(ClickType type, Player player) {
        if (this.condition != null && !this.condition.getAllBoolean(player)) {
            return;
        }
        if (this.action != null) {
            this.action.runAllActions(player);
        }
    }

    @Override
    public ItemStack getDisplayItem(Player player) {
        this.config.addDefault("name", null);
        this.config.addDefault("lore", null);
        return ItemUtil.buildItemStack(player, this.config, new String[0]);
    }
}

