/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.objects.buttons;

import cn.superiormc.mythicprefixes.api.MythicPrefixesAPI;
import cn.superiormc.mythicprefixes.libreforge.LibreforgeEffects;
import cn.superiormc.mythicprefixes.manager.CacheManager;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.objects.ObjectAction;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.ObjectCondition;
import cn.superiormc.mythicprefixes.objects.ObjectDisplayPlaceholder;
import cn.superiormc.mythicprefixes.objects.PrefixStatus;
import cn.superiormc.mythicprefixes.objects.buttons.AbstractButton;
import cn.superiormc.mythicprefixes.objects.buttons.ButtonType;
import cn.superiormc.mythicprefixes.objects.effect.AbstractEffect;
import cn.superiormc.mythicprefixes.objects.effect.EffectStatus;
import cn.superiormc.mythicprefixes.utils.CommonUtil;
import cn.superiormc.mythicprefixes.utils.ItemUtil;
import cn.superiormc.mythicprefixes.utils.SchedulerUtil;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ObjectPrefix
extends AbstractButton
implements Comparable<ObjectPrefix> {
    private final String id;
    private final ObjectAction startAction;
    private final ObjectAction endAction;
    private final ObjectAction circleAction;
    private final ObjectAction clickActionCDM;
    private final ObjectAction clickActionMXR;
    private final Map<Player, EffectStatus> mmoEffects = new HashMap<Player, EffectStatus>();
    private boolean useEffect;
    private boolean isDefaultPrefix;
    private final List<String> groups;

    public ObjectPrefix(String id, YamlConfiguration config) {
        super((ConfigurationSection)config);
        this.id = id;
        this.type = ButtonType.PREFIX;
        this.condition = new ObjectCondition(config.getConfigurationSection("conditions"));
        this.startAction = new ObjectAction(config.getConfigurationSection("equip-actions"));
        this.endAction = new ObjectAction(config.getConfigurationSection("unequip-actions"));
        this.circleAction = new ObjectAction(config.getConfigurationSection("circle-actions"));
        this.clickActionCDM = new ObjectAction(config.getConfigurationSection("click-actions.condition-not-meet"));
        this.clickActionMXR = new ObjectAction(config.getConfigurationSection("click-actions.max-limit-reached"));
        this.groups = new ArrayList<String>();
        ObjectDisplayPlaceholder.groupNames.addAll(this.groups);
    }

    public void initEffects() {
        if (this.config.getBoolean("effects.enabled", false)) {
            if (ConfigManager.configManager.getBoolean("libreforge-hook") && this.config.getBoolean("effects.enabled", false)) {
                LibreforgeEffects.libreforgeEffects.registerLibreforgeEffect(this.id);
            }
            this.useEffect = true;
        }
    }

    public boolean enabledEffect() {
        return this.config.getBoolean("effects.enabled", false);
    }

    public void runStartAction(ObjectCache cache) {
        Player player = cache.getPlayer();
        if (this.useEffect) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fStarted effect for player " + player.getName());
            this.mmoEffects.put(player, MythicPrefixesAPI.startEffect(this, player));
        }
        this.startAction.runAllActions(player);
        SchedulerUtil task = SchedulerUtil.runTaskTimer(() -> {
            if (!this.circleAction.isEmpty()) {
                this.circleAction.runAllActions(player);
            }
            if (this.mmoEffects.get(player) != null) {
                this.mmoEffects.get(player).retryActiveEffects();
            }
        }, 1L, ConfigManager.configManager.getLong("circle-actions.period-tick", 20L));
        cache.addCircleTask(this, task);
    }

    public EffectStatus getEffectStatus(Player player) {
        return this.mmoEffects.get(player);
    }

    public void runEndAction(ObjectCache cache) {
        Player player = cache.getPlayer();
        if (this.useEffect && this.mmoEffects.get(player) != null) {
            for (AbstractEffect tempVal1 : this.mmoEffects.get(player).getActivedEffects()) {
                tempVal1.removePlayerStat();
            }
            this.mmoEffects.remove(player);
        }
        this.endAction.runAllActions(player);
        cache.cancelCircleTask(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayValue(Player player) {
        return TextUtil.withPAPI(this.config.getString("display-value", "UNKNOWN"), player);
    }

    public int getWeight() {
        return this.config.getInt("weight");
    }

    public PrefixStatus getPrefixStatus(ObjectCache cache) {
        if (cache == null) {
            return PrefixStatus.CONDITION_NOT_MEET;
        }
        if (cache.getActivePrefixes().contains(this)) {
            return PrefixStatus.USING;
        }
        Player player = cache.getPlayer();
        if (this.isConditionNotMeet(cache)) {
            return PrefixStatus.CONDITION_NOT_MEET;
        }
        Collection<ObjectPrefix> nowPrefixes = MythicPrefixesAPI.getActivedPrefixes(player);
        if (nowPrefixes.size() >= MythicPrefixesAPI.getMaxPrefixesAmount(player, null)) {
            return PrefixStatus.MAX_LIMIT_REACHED;
        }
        return PrefixStatus.CAN_USE;
    }

    public boolean isConditionNotMeet(ObjectCache cache) {
        Player player = cache.getPlayer();
        if (!cache.isFinishLoad()) {
            return false;
        }
        return !this.condition.getAllBoolean(player) && !CommonUtil.checkPermission(player, "mythicprefixes.bypass." + this.getId());
    }

    public boolean getDisplayInGUI() {
        return this.config.contains("display-item", true) && !this.isDefaultPrefix();
    }

    public boolean shouldHideInGUI(Player player) {
        return !this.config.getBoolean("auto-hide", false) || this.condition.getAllBoolean(player);
    }

    @Override
    public void clickEvent(ClickType type, Player player) {
        ObjectCache cache = CacheManager.cacheManager.getPlayerCache(player);
        switch (this.getPrefixStatus(cache)) {
            case CAN_USE: {
                CacheManager.cacheManager.getPlayerCache(player).addActivePrefix(this);
                break;
            }
            case USING: {
                CacheManager.cacheManager.getPlayerCache(player).removeActivePrefix(this, true);
                break;
            }
            case CONDITION_NOT_MEET: {
                break;
            }
        }
    }

    @Override
    public ItemStack getDisplayItem(Player player) {
        ConfigurationSection section = null;
        ObjectCache cache = CacheManager.cacheManager.getPlayerCache(player);
        PrefixStatus status = this.getPrefixStatus(cache);
        if (status == PrefixStatus.CAN_USE) {
            section = this.config.getConfigurationSection("display-item.unlocked");
        } else if (status == PrefixStatus.CONDITION_NOT_MEET) {
            section = this.config.getConfigurationSection("display-item.locked");
        } else if (status == PrefixStatus.MAX_LIMIT_REACHED) {
            section = this.config.getConfigurationSection("display-item.max-reached");
        } else if (status == PrefixStatus.USING) {
            section = this.config.getConfigurationSection("display-item.using");
        }
        if (section == null) {
            if (this.config.getConfigurationSection("display-item") != null) {
                return ItemUtil.buildItemStack(player, this.config.getConfigurationSection("display-item"), "display-value", this.getDisplayValue(player), "status", MythicPrefixesAPI.getStatusPlaceholder(this, cache));
            }
            return new ItemStack(Material.STONE);
        }
        return ItemUtil.buildItemStack(player, section, "display-value", this.getDisplayValue(player), "status", MythicPrefixesAPI.getStatusPlaceholder(this, cache));
    }

    public boolean isDefaultPrefix() {
        return false;
    }

    public void setDefaultPrefix(boolean b) {
        this.isDefaultPrefix = b;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public int compareTo(@NotNull ObjectPrefix otherPrefix) {
        if (this.getWeight() == otherPrefix.getWeight()) {
            int len1 = this.getId().length();
            int len2 = otherPrefix.getId().length();
            int minLength = Math.min(len1, len2);
            for (int i = 0; i < minLength; ++i) {
                char c2;
                char c1 = this.getId().charAt(i);
                if (c1 == (c2 = otherPrefix.getId().charAt(i))) continue;
                if (Character.isDigit(c1) && Character.isDigit(c2)) {
                    return Integer.compare(Integer.parseInt(this.getId().substring(i)), Integer.parseInt(otherPrefix.getId().substring(i)));
                }
                return c1 - c2;
            }
            return len1 - len2;
        }
        return this.getWeight() - otherPrefix.getWeight();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectPrefix) {
            ObjectPrefix prefix = (ObjectPrefix)obj;
            return prefix.getId().equals(this.getId());
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }
}

