/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.objects.effect;

import cn.superiormc.mythicprefixes.manager.ErrorManager;
import cn.superiormc.mythicprefixes.objects.effect.AbstractEffect;
import cn.superiormc.mythicprefixes.objects.effect.ObjectMMEffectSource;
import cn.superiormc.mythicprefixes.utils.SchedulerUtil;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ObjectMMEffect
extends AbstractEffect {
    private final StatModifierType modifier;
    private final ObjectMMEffectSource source;
    private StatType statType;

    public ObjectMMEffect(String id, Player player, ConfigurationSection section) {
        super(id, player, section);
        this.player = player;
        this.modifier = StatModifierType.get((String)section.getString("modifier-type", "ADD").toUpperCase());
        this.source = new ObjectMMEffectSource(this);
        Optional statTypeOptional = MythicBukkit.inst().getStatManager().getStat(section.getString("stat", ""));
        statTypeOptional.ifPresent(type -> {
            this.statType = type;
        });
    }

    @Override
    public void addPlayerStat() {
        if (this.statType == null || this.modifier == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a76Warning: Failed to add MythicMobs effect for player. Reason: Config Error");
            return;
        }
        PlayerData profile = (PlayerData)MythicBukkit.inst().getPlayerManager().getProfile(this.player);
        if (profile == null) {
            ++this.retryTimes;
            if (this.retryTimes < 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a76Warning: Failed to add MythicMobs effect for player " + this.player.getName() + ", don't worry, we will retry later. Retry Times: " + this.retryTimes + ".");
                SchedulerUtil.runTaskLater(this::addPlayerStat, 20L);
            } else {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to add MythicMobs effect for player " + this.player.getName() + ", if this always happen, try change cache.load-mode option to JOIN in config.yml file, if it only happens sometimes, just ignore this and ask this player equip the prefix again! This because effect plugin load data is slower than MythicPrefixes this times.");
            }
            return;
        }
        StatRegistry stats = profile.getStatRegistry();
        if (stats == null) {
            ++this.retryTimes;
            if (this.retryTimes < 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a76Warning: Failed to add MythicMobs effect for player " + this.player.getName() + ", don't worry, we will retry later. Retry Times: " + this.retryTimes + ".");
                SchedulerUtil.runTaskLater(this::addPlayerStat, 20L);
            } else {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to add MythicMobs effect for player " + this.player.getName() + ", if this always happen, try change cache.load-mode option to JOIN in config.yml file, if it only happens sometimes, just ignore this and ask this player equip the prefix again! This because effect plugin load data is slower than MythicPrefixes this times.");
            }
            return;
        }
        stats.putValue(this.statType, (StatSource)this.source, this.modifier, this.section.getDouble("value", 0.0));
    }

    @Override
    public void removePlayerStat() {
        PlayerData profile = (PlayerData)MythicBukkit.inst().getPlayerManager().getProfile(this.player);
        if (profile != null) {
            StatRegistry stats = profile.getStatRegistry();
            stats.removeValue(this.statType, (StatSource)this.source);
        }
    }
}

