/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.objects.effect;

import cn.superiormc.mythicprefixes.manager.ErrorManager;
import cn.superiormc.mythicprefixes.objects.effect.AbstractEffect;
import cn.superiormc.mythicprefixes.utils.SchedulerUtil;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ObjectMMOEffect
extends AbstractEffect {
    private final StatModifier modifier;
    private final String stat;

    public ObjectMMOEffect(String id, Player player, ConfigurationSection section) {
        super(id, player, section);
        this.player = player;
        this.stat = section.getString("stat", "");
        this.modifier = new StatModifier("MythicPrefixes_" + id, this.stat, section.getDouble("value", 0.0), ModifierType.FLAT);
    }

    @Override
    public void addPlayerStat() {
        try {
            if (MMOPlayerData.has((OfflinePlayer)this.player)) {
                MMOPlayerData playerData = MMOPlayerData.get((OfflinePlayer)this.player);
                StatMap statMap = playerData.getStatMap();
                this.modifier.register(playerData);
                statMap.getInstance(this.stat).addModifier(this.modifier);
            } else {
                ++this.retryTimes;
                if (this.retryTimes < 3) {
                    ErrorManager.errorManager.sendErrorMessage("\u00a76Warning: Failed to add MMO effect for player " + this.player.getName() + ", don't worry, we will retry later. Retry Times: " + this.retryTimes + ".");
                    SchedulerUtil.runTaskLater(this::addPlayerStat, 20L);
                } else {
                    ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to add MMO effect for player " + this.player.getName() + ", if this always happen, try change cache.load-mode option to JOIN in config.yml file, if it only happens sometimes, just ignore this and ask this player equip the prefix again! This because MMO load data is slower than MythicPrefixes this times.");
                }
            }
        }
        catch (Throwable throwable) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to add MMO effect for player " + this.player.getName() + ", if this always happen, try change cache.load-mode option to JOIN in config.yml file, if it only happens sometimes, just ignore this and ask this player equip the prefix again! This because MMO load data is slower than MythicPrefixes this times.");
        }
    }

    @Override
    public void removePlayerStat() {
        this.retryTimes = 0;
        if (this.retryTask != null) {
            this.retryTask.cancel();
            this.retryTask = null;
        }
        if (this.player.isOnline()) {
            MMOPlayerData playerData = MMOPlayerData.get((OfflinePlayer)this.player);
            StatMap statMap = playerData.getStatMap();
            statMap.getInstance(this.stat).remove("MythicPrefixes_" + this.id);
        }
    }
}

