/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.paper;

import cn.superiormc.mythicprefixes.MythicPrefixes;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.paper.utils.PaperTextUtil;
import cn.superiormc.mythicprefixes.utils.SpecialMethodUtil;
import cn.superiormc.mythicprefixes.utils.TextUtil;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class PaperMethodUtil
implements SpecialMethodUtil {
    @Override
    public String methodID() {
        return "paper";
    }

    @Override
    public void dispatchCommand(String command) {
        if (MythicPrefixes.isFolia) {
            Bukkit.getGlobalRegionScheduler().run((Plugin)MythicPrefixes.instance, task -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
            return;
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    @Override
    public void dispatchCommand(Player player, String command) {
        if (MythicPrefixes.isFolia) {
            player.getScheduler().run((Plugin)MythicPrefixes.instance, task -> Bukkit.dispatchCommand((CommandSender)player, (String)command), () -> {});
            return;
        }
        Bukkit.dispatchCommand((CommandSender)player, (String)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchOpCommand(Player player, String command) {
        if (MythicPrefixes.isFolia) {
            player.getScheduler().run((Plugin)MythicPrefixes.instance, task -> {
                boolean playerIsOp = player.isOp();
                try {
                    player.setOp(true);
                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                }
                finally {
                    player.setOp(playerIsOp);
                }
            }, () -> {});
            return;
        }
        boolean playerIsOp = player.isOp();
        try {
            player.setOp(true);
            Bukkit.dispatchCommand((CommandSender)player, (String)command);
        }
        finally {
            player.setOp(playerIsOp);
        }
    }

    @Override
    public void spawnEntity(Location location, EntityType entity) {
        if (MythicPrefixes.isFolia) {
            Bukkit.getRegionScheduler().run((Plugin)MythicPrefixes.instance, location, task -> location.getWorld().spawnEntity(location, entity));
            return;
        }
        location.getWorld().spawnEntity(location, entity);
    }

    @Override
    public void playerTeleport(Player player, Location location) {
        if (MythicPrefixes.isFolia) {
            player.teleportAsync(location);
        } else {
            player.teleport(location);
        }
    }

    @Override
    public SkullMeta setSkullMeta(SkullMeta meta, String skull) {
        PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID(), (String)"");
        profile.setProperty(new ProfileProperty("textures", skull));
        meta.setPlayerProfile(profile);
        return meta;
    }

    @Override
    public void setItemName(ItemMeta meta, String name, Player player) {
        if (PaperTextUtil.containsLegacyCodes((String)name)) {
            name = "<!i>" + (String)name;
        }
        meta.displayName(PaperTextUtil.modernParse((String)name, player));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setItemLore(ItemMeta meta, List<String> lores, Player player) {
        ArrayList<Component> veryNewLore = new ArrayList<Component>();
        for (String lore : lores) {
            for (String string : lore.split("\n")) {
                void var10_10;
                if (PaperTextUtil.containsLegacyCodes(string)) {
                    String string2 = "<!i>" + string;
                }
                veryNewLore.add(PaperTextUtil.modernParse((String)var10_10, player));
            }
        }
        if (!veryNewLore.isEmpty()) {
            meta.lore(veryNewLore);
        }
    }

    @Override
    public void sendMessage(Player player, String text) {
        if (player == null) {
            Bukkit.getConsoleSender().sendMessage(PaperTextUtil.modernParse(text));
        } else {
            player.sendMessage(PaperTextUtil.modernParse(text, player));
        }
    }

    @Override
    public void sendTitle(Player player, String title, String subTitle, int fadeIn, int stay, int fadeOut) {
        player.showTitle(Title.title((Component)PaperTextUtil.modernParse(title), (Component)PaperTextUtil.modernParse(subTitle), (Title.Times)Title.Times.times((Duration)Ticks.duration((long)fadeIn), (Duration)Ticks.duration((long)stay), (Duration)Ticks.duration((long)fadeOut))));
    }

    @Override
    public Inventory createNewInv(Player player, int size, String text) {
        return Bukkit.createInventory((InventoryHolder)player, (int)size, (Component)PaperTextUtil.modernParse(text, player));
    }

    @Override
    public String legacyParse(String text) {
        if (text == null) {
            return "";
        }
        if (!ConfigManager.configManager.getBoolean("config-files.force-parse-mini-message")) {
            return TextUtil.colorize(text);
        }
        return LegacyComponentSerializer.legacySection().serialize(PaperTextUtil.modernParse(text));
    }

    @Override
    public String getItemName(ItemMeta meta) {
        return PaperTextUtil.changeToString(meta.displayName());
    }
}

