/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.papi;

import cn.superiormc.mythicprefixes.MythicPrefixes;
import cn.superiormc.mythicprefixes.api.MythicPrefixesAPI;
import cn.superiormc.mythicprefixes.manager.CacheManager;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.manager.LanguageManager;
import cn.superiormc.mythicprefixes.objects.ObjectCache;
import cn.superiormc.mythicprefixes.objects.ObjectDisplayPlaceholder;
import cn.superiormc.mythicprefixes.objects.buttons.ObjectPrefix;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPIExpansion
extends PlaceholderExpansion {
    public static PlaceholderAPIExpansion papi = null;
    private final MythicPrefixes plugin;

    public boolean canRegister() {
        return true;
    }

    public PlaceholderAPIExpansion(MythicPrefixes plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getAuthor() {
        return "PQguanfang";
    }

    @NotNull
    public String getIdentifier() {
        return "mythicprefixes";
    }

    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, String params) {
        Player player = offlinePlayer.getPlayer();
        if (player == null || params == null || params.isEmpty()) {
            return null;
        }
        ObjectCache cache = CacheManager.cacheManager.getPlayerCache(player);
        if (cache == null) {
            return null;
        }
        if (params.equals("amount")) {
            return String.valueOf(cache.getActivePrefixes().size());
        }
        if (params.startsWith("status_")) {
            String prefixId = params.substring("status_".length());
            ObjectPrefix prefix = ConfigManager.configManager.getPrefix(prefixId);
            if (prefix == null) {
                return LanguageManager.languageManager.getStringText("placeholderapi.unknown-prefix");
            }
            return String.valueOf((Object)prefix.getPrefixStatus(cache));
        }
        if (params.startsWith("prefix_")) {
            String sub = params.substring("prefix_".length());
            int splitIndex = sub.lastIndexOf("_");
            if (splitIndex != -1) {
                String prefixId = sub.substring(0, splitIndex);
                String displayId = sub.substring(splitIndex + 1);
                ObjectPrefix prefix = ConfigManager.configManager.getPrefix(prefixId);
                if (prefix == null) {
                    return LanguageManager.languageManager.getStringText("placeholderapi.unknown-prefix");
                }
                ObjectDisplayPlaceholder displayPlaceholder = ConfigManager.configManager.getDisplayPlaceholder(displayId);
                if (displayPlaceholder == null) {
                    return LanguageManager.languageManager.getStringText("placeholderapi.unknown-display-placeholder");
                }
                return displayPlaceholder.getDisplayText(cache, prefix);
            }
        } else {
            if (params.startsWith("no_")) {
                // empty if block
            }
            if (params.equals("max")) {
                return String.valueOf(MythicPrefixesAPI.getMaxPrefixesAmount(player, null));
            }
            ObjectDisplayPlaceholder displayPlaceholder = ConfigManager.configManager.getDisplayPlaceholder(params);
            if (displayPlaceholder == null) {
                return LanguageManager.languageManager.getStringText("placeholderapi.unknown-display-placeholder");
            }
            return displayPlaceholder.getDisplayText(cache);
        }
        return null;
    }
}

