/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.utils;

import cn.superiormc.mythicprefixes.MythicPrefixes;
import cn.superiormc.mythicprefixes.manager.ConfigManager;
import cn.superiormc.mythicprefixes.manager.ErrorManager;
import cn.superiormc.mythicprefixes.utils.CommonUtil;
import com.google.common.base.Enums;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class ItemUtil {
    public static ItemStack buildItemStack(@NotNull Player player, @Nullable ConfigurationSection section, String ... args) {
        ConfigurationSection enchantsKey;
        List itemFlagKey;
        int customModelDataKey;
        List loreKey;
        ItemMeta meta;
        int amountKey;
        Material material;
        ItemStack item = new ItemStack(Material.STONE);
        if (section == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not parse item because the config section is null.");
            return item;
        }
        String materialKey = section.getString("material");
        if (materialKey != null && (material = Material.getMaterial((String)materialKey.toUpperCase())) != null) {
            item.setType(material);
        }
        if ((amountKey = section.getInt("amount", -1)) > 0) {
            item.setAmount(amountKey);
        }
        if ((meta = item.getItemMeta()) == null) {
            return item;
        }
        String displayNameKey = section.getString("name");
        if (displayNameKey != null) {
            MythicPrefixes.methodUtil.setItemName(meta, CommonUtil.modifyString(displayNameKey, args), player);
        }
        if (!(loreKey = section.getStringList("lore")).isEmpty()) {
            MythicPrefixes.methodUtil.setItemLore(meta, CommonUtil.modifyList(player, loreKey, args), player);
        }
        if (CommonUtil.getMajorVersion(14) && (customModelDataKey = section.getInt("custom-model-data", section.getInt("cmd", -1))) > 0) {
            meta.setCustomModelData(Integer.valueOf(customModelDataKey));
        }
        if (!(itemFlagKey = section.getStringList("flags")).isEmpty()) {
            for (Object flag : itemFlagKey) {
                ItemFlag itemFlag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)(flag = ((String)flag).toUpperCase())).orNull();
                if (itemFlag != null) {
                    meta.addItemFlags(new ItemFlag[]{itemFlag});
                }
                if (!CommonUtil.getMinorVersion(20, 6) || itemFlag != ItemFlag.HIDE_ATTRIBUTES || meta.getAttributeModifiers() != null) continue;
                meta.setAttributeModifiers((Multimap)MultimapBuilder.hashKeys().hashSetValues().build());
            }
        }
        if ((enchantsKey = section.getConfigurationSection("enchants")) != null) {
            for (String ench : enchantsKey.getKeys(false)) {
                Enchantment vanillaEnchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)ench.toLowerCase()));
                if (vanillaEnchant == null) continue;
                meta.addEnchant(vanillaEnchant, enchantsKey.getInt(ench), true);
            }
        }
        if (CommonUtil.getMinorVersion(20, 5) && section.get("glow") != null) {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(section.getBoolean("glow")));
        }
        if (CommonUtil.getMinorVersion(21, 2)) {
            // empty if block
        }
        if (meta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)meta;
            String skullTextureNameKey = section.getString("skull-meta", section.getString("skull"));
            if (skullTextureNameKey != null) {
                MythicPrefixes.methodUtil.setSkullMeta(skullMeta, skullTextureNameKey);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static String getItemNameWithoutVanilla(ItemStack displayItem) {
        if (displayItem == null || displayItem.getItemMeta() == null) {
            return "";
        }
        if (displayItem.getItemMeta().hasDisplayName()) {
            return MythicPrefixes.methodUtil.getItemName(displayItem.getItemMeta());
        }
        if (MythicPrefixes.methodUtil.methodID().equals("paper") && ConfigManager.configManager.getBoolean("choose-prefix-gui.auto-translate-item-name")) {
            return "<lang:" + displayItem.translationKey() + ">";
        }
        StringBuilder result = new StringBuilder();
        for (String word : displayItem.getType().name().toLowerCase().split("_")) {
            if (word.isEmpty()) continue;
            char firstChar = Character.toUpperCase(word.charAt(0));
            String restOfWord = word.substring(1);
            result.append(firstChar).append(restOfWord).append(" ");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }
}

