/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicprefixes.utils;

import cn.superiormc.mythicprefixes.MythicPrefixes;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SchedulerUtil {
    private BukkitTask bukkitTask;
    private ScheduledTask scheduledTask;

    public SchedulerUtil(BukkitTask bukkitTask) {
        this.bukkitTask = bukkitTask;
    }

    public SchedulerUtil(ScheduledTask scheduledTask) {
        this.scheduledTask = scheduledTask;
    }

    public void cancel() {
        if (MythicPrefixes.isFolia) {
            this.scheduledTask.cancel();
        } else {
            this.bukkitTask.cancel();
        }
    }

    public static void runSync(Runnable task) {
        if (MythicPrefixes.isFolia) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)MythicPrefixes.instance, task);
        } else {
            Bukkit.getScheduler().runTask((Plugin)MythicPrefixes.instance, task);
        }
    }

    public static void runTaskAsynchronously(Runnable task) {
        if (MythicPrefixes.isFolia) {
            task.run();
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)MythicPrefixes.instance, task);
        }
    }

    public static SchedulerUtil runTaskLater(Runnable task, long delayTicks) {
        if (MythicPrefixes.isFolia) {
            if (delayTicks <= 0L) {
                delayTicks = 1L;
            }
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)MythicPrefixes.instance, scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLater((Plugin)MythicPrefixes.instance, task, delayTicks));
    }

    public static SchedulerUtil runTaskTimer(Runnable task, long delayTicks, long periodTicks) {
        if (MythicPrefixes.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)MythicPrefixes.instance, scheduledTask -> task.run(), delayTicks, periodTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskTimer((Plugin)MythicPrefixes.instance, task, delayTicks, periodTicks));
    }

    public static SchedulerUtil runTaskLaterAsynchronously(Runnable task, long delayTicks) {
        if (MythicPrefixes.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)MythicPrefixes.instance, scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)MythicPrefixes.instance, task, delayTicks));
    }
}

