/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.sailstatus;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.ActivityType;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.Packet;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.User;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.meteordev.starscript.value.Value;
import org.meteordev.starscript.value.ValueMap;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.api.events.alinlib.LocalizationEvents;
import ru.kelcuprum.alinlib.api.events.client.ClientLifecycleEvents;
import ru.kelcuprum.alinlib.config.Config;
import ru.kelcuprum.alinlib.config.Localization;
import ru.kelcuprum.sailstatus.config.Assets;
import ru.kelcuprum.sailstatus.config.ModConfig;
import ru.kelcuprum.sailstatus.info.Client;
import ru.kelcuprum.sailstatus.info.PresencePlayer;
import ru.kelcuprum.sailstatus.info.PresenceWorld;
import ru.kelcuprum.sailstatus.mods.FlashbackComp;
import ru.kelcuprum.sailstatus.mods.ReplayModComp;
import ru.kelcuprum.sailstatus.mods.Voice;
import ru.kelcuprum.sailstatus.mods.WaterPlayerSupport;
import ru.kelcuprum.sailstatus.presence.LoadingResources;
import ru.kelcuprum.sailstatus.presence.Unknown;
import ru.kelcuprum.sailstatus.presence.ingame.MultiPlayer;
import ru.kelcuprum.sailstatus.presence.ingame.SaveWorld;
import ru.kelcuprum.sailstatus.presence.ingame.SinglePlayer;
import ru.kelcuprum.sailstatus.presence.menu.Connect;
import ru.kelcuprum.sailstatus.presence.menu.Disconnect;
import ru.kelcuprum.sailstatus.presence.menu.Loading;
import ru.kelcuprum.sailstatus.presence.menu.MainMenu;
import ru.kelcuprum.sailstatus.presence.mods.Flashback;
import ru.kelcuprum.sailstatus.presence.mods.ReplayMod;

public class SailStatus
implements ClientModInitializer {
    public static Config userConfig = new Config("config/SailStatus/config.json");
    public static Config serverConfig = new Config("config/SailStatus/servers/default.json");
    public static Localization localization = new Localization("sailstatus.presence", "config/SailStatus/lang");
    public static HashMap<String, Assets> assets = new HashMap();
    public static HashMap<String, Assets> modAssets = new HashMap();
    public static ArrayList<String> assetsNames = new ArrayList();
    public static double isPEnable = Math.random();
    private static String lastException;
    public static Long TIME_STARTED_CLIENT;
    public static final Logger LOG;
    public static Boolean replayMod;
    public static Boolean waterPlayer;
    public static Boolean svc;
    public static Boolean plasmo;
    public static Boolean klashback;
    public static Boolean isVoiceModsEnable;
    public static Boolean isMusicModsEnable;
    public static RichPresence lastPresence;
    public static IPCClient client;
    public static User USER;
    public static String APPLICATION_ID;
    public static boolean CONNECTED;
    public static boolean GAME_STARTED;
    public static WaterPlayerSupport waterPlayerSupport;
    private static final Timer TIMER;
    public static boolean EMPTY;

    public static void log(String message) {
        SailStatus.log(message, Level.INFO);
    }

    public static void log(String message, Level level) {
        LOG.log(level, "[" + LOG.getName() + "] " + message);
    }

    public void onInitializeClient() {
        replayMod = FabricLoader.getInstance().getModContainer("replaymod").isPresent();
        waterPlayer = FabricLoader.getInstance().getModContainer("waterplayer").isPresent();
        svc = FabricLoader.getInstance().getModContainer("voicechat").isPresent();
        plasmo = FabricLoader.getInstance().getModContainer("plasmovoice").isPresent();
        klashback = FabricLoader.getInstance().getModContainer("flashback").isPresent();
        isVoiceModsEnable = svc != false || plasmo != false;
        isMusicModsEnable = waterPlayer;
        userConfig.load();
        serverConfig.load();
        try {
            ModConfig.load();
        }
        catch (Exception e) {
            SailStatus.log("The default configuration of the mod was not loaded, no launch possible!", Level.ERROR);
            SailStatus.log(e.getLocalizedMessage(), Level.ERROR);
            return;
        }
        Assets.loadFiles();
        ClientLifecycleEvents.CLIENT_FULL_STARTED.register(client -> {
            TIME_STARTED_CLIENT = SailStatus.parseSeconds(System.currentTimeMillis());
            GAME_STARTED = true;
            SailStatus.startClient();
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client1 -> SailStatus.exitApplication());
        LocalizationEvents.DEFAULT_PARSER_INIT.register(parser -> {
            parser.ss.set("player.scene", () -> Value.string((String)PresenceWorld.getScene()));
            parser.ss.set("player.name", () -> Value.string((String)PresencePlayer.getName()));
            parser.ss.set("discord", new ValueMap().set("name", () -> Value.string((String)USER.getName())).set("nickname", () -> Value.string((String)USER.getNickname())).set("discriminator", () -> Value.string((String)USER.getDiscriminator())).set("id", () -> Value.string((String)USER.getId())).set("avatar", () -> Value.string((String)USER.getAvatarUrl())));
            if (isVoiceModsEnable.booleanValue()) {
                parser.ss.set("voice", new ValueMap().set("listener", () -> Value.string((String)new Voice().listener)));
            }
            if (replayMod.booleanValue()) {
                parser.ss.set("replay", new ValueMap().set("date", () -> Value.string((String)SailStatus.getReplayDateFormat())).set("name", () -> Value.string((String)(userConfig.getBoolean("VIEW_REPLAY_MOD_SERVER_NAME", true) ? new ReplayModComp().name : new ReplayModComp().address))));
            }
            if (klashback.booleanValue()) {
                parser.ss.set("flashback.replay", new ValueMap().set("date", () -> Value.string((String)SailStatus.getReplayDateFormat$flashback())).set("name", () -> Value.string((String)new FlashbackComp().name)));
            }
        });
    }

    public static String getReplayDateFormat() {
        String strDateFormat = localization.getLocalization("mod.replaymod.date_format", false);
        SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
        return dateFormat.format(new ReplayModComp().date);
    }

    public static String getReplayDateFormat$flashback() {
        String strDateFormat = localization.getLocalization("mod.flashback.date_format", false);
        SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
        return dateFormat.format(new FlashbackComp().date);
    }

    public static long parseSeconds(long mills) {
        return (mills - mills % 1000L) / 1000L;
    }

    private static void start() {
        TIMER.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                block2: {
                    try {
                        SailStatus.updatePresence();
                    }
                    catch (Exception ex) {
                        if (lastException != null && lastException.equals(ex.getMessage())) break block2;
                        lastException = ex.getMessage();
                        SailStatus.log(ex.getLocalizedMessage(), Level.ERROR);
                        RichPresence.Builder presence = new RichPresence.Builder().setActivityType(ActivityType.Competing).setDetails("There was an error, look in the console").setState("And report the bug on GitHub").setLargeImage(Assets.getSelected().getIcon("unknown"));
                        if (!CONNECTED) break block2;
                        SailStatus.sendPresence(presence.build());
                    }
                }
            }
        }, 250L, 250L);
    }

    public static void startClient() {
        SailStatus.registerApplication();
        SailStatus.start();
        SailStatus.log(String.format("Client %s is up and running!", AlinLib.MINECRAFT.method_1515()));
    }

    private static void registerApplication() {
        if (!CONNECTED) {
            String string = APPLICATION_ID = userConfig.getBoolean("USE_ANOTHER_ID", false) ? ModConfig.mineID : ModConfig.baseID;
            if (userConfig.getBoolean("USE_CUSTOM_APP_ID", false) && !userConfig.getString("CUSTOM_APP_ID", ModConfig.baseID).isBlank()) {
                APPLICATION_ID = userConfig.getString("CUSTOM_APP_ID", ModConfig.baseID);
            }
            client = new IPCClient(Long.parseLong(APPLICATION_ID));
            SailStatus.setupListener();
            try {
                client.connect(new DiscordBuild[0]);
            }
            catch (Exception ex) {
                SailStatus.log(ex.getLocalizedMessage(), Level.ERROR);
            }
        } else {
            SailStatus.log("The client is already running");
        }
    }

    public static void exitApplication() {
        if (CONNECTED) {
            SailStatus.log("Client stopped");
            CONNECTED = false;
            client.close();
        }
    }

    public static void setupListener() {
        client.setListener(new IPCListener(){

            @Override
            public void onPacketSent(IPCClient ipcClient, Packet packet) {
            }

            @Override
            public void onPacketReceived(IPCClient ipcClient, Packet packet) {
            }

            @Override
            public void onActivityJoin(IPCClient ipcClient, String s) {
            }

            @Override
            public void onActivitySpectate(IPCClient ipcClient, String s) {
            }

            @Override
            public void onActivityJoinRequest(IPCClient ipcClient, String s, User user) {
            }

            @Override
            public void onReady(IPCClient client) {
                SailStatus.log("The mod has been connected to Discord", Level.DEBUG);
                USER = client.getCurrentUser();
                CONNECTED = true;
            }

            @Override
            public void onClose(IPCClient ipcClient, JsonObject jsonObject) {
                CONNECTED = false;
            }

            @Override
            public void onDisconnect(IPCClient ipcClient, Throwable throwable) {
                SailStatus.log("The mod has been pulled from Discord", Level.DEBUG);
                SailStatus.log(String.format("Reason: %s", throwable.getLocalizedMessage()), Level.DEBUG);
                CONNECTED = false;
            }
        });
    }

    private static void updatePresence() {
        if (userConfig.getBoolean("SHOW_RPC", true)) {
            if (waterPlayer.booleanValue()) {
                waterPlayerSupport.update();
            }
            if (AlinLib.MINECRAFT.field_1687 != null && AlinLib.MINECRAFT.field_1724 != null) {
                if (replayMod.booleanValue() && ReplayModComp.isInReplay() && userConfig.getBoolean("VIEW_REPLAY_MOD", true)) {
                    new ReplayMod();
                } else if (klashback.booleanValue() && FlashbackComp.isInReplay() && userConfig.getBoolean("VIEW_REPLAY_MOD", true)) {
                    new Flashback();
                } else if (AlinLib.MINECRAFT.method_47392() || AlinLib.MINECRAFT.method_1496()) {
                    new SinglePlayer();
                } else if (AlinLib.MINECRAFT.method_1558() != null) {
                    new MultiPlayer();
                } else {
                    switch (Client.getState()) {
                        case 1: {
                            new LoadingResources();
                            break;
                        }
                        case 2: {
                            new Loading();
                            break;
                        }
                        case 3: {
                            new Connect();
                            break;
                        }
                        case 4: {
                            new Disconnect();
                            break;
                        }
                        case 5: {
                            new SaveWorld();
                            break;
                        }
                        default: {
                            new Unknown();
                            break;
                        }
                    }
                }
            } else {
                switch (Client.getState()) {
                    case 1: {
                        new LoadingResources();
                        break;
                    }
                    case 2: {
                        new Loading();
                        break;
                    }
                    case 3: {
                        new Connect();
                        break;
                    }
                    case 4: {
                        new Disconnect();
                        break;
                    }
                    default: {
                        new MainMenu();
                        break;
                    }
                }
            }
        } else {
            SailStatus.sendPresence(null);
        }
    }

    public static void updateContentPresenceByConfigs(RichPresence.Builder presence) {
        SailStatus.updateContentPresenceByConfigs(presence, false);
    }

    public static void updateContentPresenceByConfigs(RichPresence.Builder presence, boolean isServer) {
        SailStatus.updateContentPresenceByConfigs(presence, isServer, false);
    }

    public static void updateContentPresenceByConfigs(RichPresence.Builder presence, boolean isServer, boolean isMenu) {
        if (userConfig.getBoolean("SHOW_GAME_TIME", true)) {
            presence.setStartTimestamp(TIME_STARTED_CLIENT);
        }
        if (userConfig.getBoolean("VIEW_VOICE_SPEAK", false) && isVoiceModsEnable.booleanValue() && new Voice().isSpeak) {
            Voice mod = new Voice();
            String info = mod.isSelfTalk ? localization.getLocalization("mod.voice", false) : (mod.isOnePlayer ? localization.getLocalization("mod.voice.one", false) : localization.getLocalization("mod.voice.more", false));
            presence.setSmallImage(Assets.getSelected().getIcon("voice"), localization.getParsedText(info));
        } else if (userConfig.getBoolean("VIEW_MUSIC_LISTENER", false) && isMusicModsEnable.booleanValue() && !SailStatus.waterPlayerSupport.paused.booleanValue() && !isMenu) {
            presence.setSmallImage(Assets.getSelected().getIcon("music"), localization.getLocalization(SailStatus.waterPlayerSupport.artistIsNull != false ? "mod.music.noauthor" : "mod.music", true));
        } else if (isServer && serverConfig.getBoolean("SHOW_ICON", false) && !serverConfig.getString("ICON_URL", "").isEmpty()) {
            presence.setSmallImage(serverConfig.getString("ICON_URL", "").replace("%address%", Objects.requireNonNull(AlinLib.MINECRAFT.method_1558()).field_3761), localization.getParsedText("{player.scene}"));
        } else if (userConfig.getBoolean("SHOW_AVATAR_PLAYER", true)) {
            presence.setSmallImage(PresencePlayer.getURLAvatar(), PresencePlayer.getName());
        }
        if (userConfig.getBoolean("BUTTON.ENABLE", false)) {
            JsonArray buttons = new JsonArray();
            if (!userConfig.getString("BUTTON.LABEL", "").isBlank() && !userConfig.getString("BUTTON.URL", "").isBlank()) {
                JsonObject button = new JsonObject();
                button.addProperty("label", userConfig.getString("BUTTON.LABEL", ""));
                button.addProperty("url", userConfig.getString("BUTTON.URL", ""));
                buttons.add(button);
            }
            presence.setButtons(buttons);
        }
    }

    public static void sendPresence(RichPresence presence) {
        if (!EMPTY && CONNECTED && presence == null) {
            if (lastPresence != null) {
                SailStatus.exitApplication();
            }
            lastPresence = null;
            EMPTY = true;
        } else if (!(presence == null || lastPresence != null && lastPresence.toJson().toString().equalsIgnoreCase(presence.toJson().toString()))) {
            if (EMPTY) {
                SailStatus.registerApplication();
            }
            EMPTY = false;
            try {
                if (CONNECTED) {
                    client.sendRichPresence(presence);
                }
                lastPresence = presence;
            }
            catch (Exception ex) {
                SailStatus.log(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage(), Level.ERROR);
            }
        }
    }

    public static void reconnectApp() {
        SailStatus.exitApplication();
        lastPresence = null;
        SailStatus.registerApplication();
    }

    static {
        TIME_STARTED_CLIENT = 0L;
        LOG = LogManager.getLogger((String)"SailStatus");
        replayMod = false;
        waterPlayer = false;
        svc = false;
        plasmo = false;
        klashback = false;
        isVoiceModsEnable = false;
        isMusicModsEnable = false;
        CONNECTED = false;
        GAME_STARTED = false;
        waterPlayerSupport = new WaterPlayerSupport();
        TIMER = new Timer();
        EMPTY = true;
    }

    public static interface ICONS {
        public static final class_2960 MULTIPLAYER = class_2960.method_60655((String)"sailstatus", (String)"textures/gui/multiplayer.png");
        public static final class_2960 ASSETS = class_2960.method_60655((String)"sailstatus", (String)"textures/gui/assets.png");
        public static final class_2960 MONITOR = class_2960.method_60655((String)"sailstatus", (String)"textures/gui/monitor.png");
        public static final class_2960 ACCESSIBILITY = class_2960.method_60655((String)"sailstatus", (String)"textures/gui/accessibility.png");
        public static final class_2960 LANGUAGE = class_2960.method_60655((String)"sailstatus", (String)"textures/gui/language.png");
    }
}

