/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.sailstatus.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_3518;
import org.apache.commons.io.IOUtils;
import ru.kelcuprum.sailstatus.config.Assets;

public class ModConfig {
    public static boolean debugPresence = false;
    public static String baseID = "";
    public static String mineID = "";
    public static Assets defaultAssets;
    public static String MOD_CONFIG_STRING;

    public static void load() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream("sailstatus.config.json");
        if (stream == null) {
            throw new RuntimeException("stream is null!");
        }
        MOD_CONFIG_STRING = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        JsonObject config = class_3518.method_15285((String)MOD_CONFIG_STRING);
        for (String key : config.keySet()) {
            switch (key.toLowerCase()) {
                case "baseid": {
                    baseID = config.get(key).getAsString();
                    break;
                }
                case "debugpresence": {
                    debugPresence = config.get(key).getAsBoolean();
                    break;
                }
                case "mineid": {
                    mineID = config.get(key).getAsString();
                    break;
                }
                case "assets": {
                    JsonArray json = config.get(key).getAsJsonArray();
                    for (JsonElement object : json) {
                        if (!object.isJsonObject()) continue;
                        Assets assets = new Assets(object.getAsJsonObject());
                        if (defaultAssets == null) {
                            defaultAssets = assets;
                        } else {
                            assets.setDefaultAssets(defaultAssets);
                        }
                        Assets.registerAsset(assets);
                    }
                    break;
                }
            }
        }
        if (baseID.isBlank()) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d baseID, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043c\u043e\u0434\u0430!");
        }
        if (defaultAssets == null) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u0438\u043a\u043e\u043d\u043a\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043c\u043e\u0434\u0430!");
        }
        MOD_CONFIG_STRING = config.toString();
    }

    public static String[] jsonArrayToStringArray(JsonArray jsonArray) {
        int arraySize = jsonArray.size();
        String[] stringArray = new String[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            stringArray[i] = jsonArray.get(i).getAsString();
        }
        return stringArray;
    }

    static {
        MOD_CONFIG_STRING = "";
    }
}

