/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.sailstatus.gui.assets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import ru.kelcuprum.alinlib.config.Localization;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.components.ConfigureScrolWidget;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.editbox.EditBoxBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.selector.SelectorBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.kelcuprum.alinlib.gui.components.text.CategoryBox;
import ru.kelcuprum.alinlib.gui.components.text.TextBox;
import ru.kelcuprum.sailstatus.SailStatus;
import ru.kelcuprum.sailstatus.config.Assets;
import ru.kelcuprum.sailstatus.config.ModConfig;

public class AssetsScreen
extends class_437 {
    private final Assets assets;
    private final class_437 parent;
    boolean isDeleted = false;
    boolean isSelected = false;
    public TextBox descriptionBox;
    private ConfigureScrolWidget scroller;
    private List<class_339> widgets = new ArrayList<class_339>();

    public AssetsScreen(class_437 parent, Assets assets) {
        super((class_2561)class_2561.method_43471((String)"sailstatus.config.assets"));
        this.parent = parent;
        this.assets = assets;
    }

    protected void method_25426() {
        assert (this.field_22787 != null);
        this.isSelected = SailStatus.userConfig.getString("USE_ASSETS", ModConfig.defaultAssets.id).equals(this.assets.id);
        this.initPanel();
        this.initContent();
    }

    public void initPanel() {
        int x = 5;
        int size = 180;
        this.method_37063((class_364)new TextBuilder(this.field_22785).setSize(size, 9).setPosition(x, 15).build());
        this.method_37063((class_364)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.assets.title"), s -> {
            this.assets.setName((String)s);
            if (this.descriptionBox != null) {
                this.descriptionBox.setDescription(Localization.toText((String)String.format(class_2561.method_43471((String)"sailstatus.assets.description").getString(), this.assets.name)));
            }
        }).setValue(this.assets.name).setPosition(x, 40).setSize(size, 20).build());
        this.method_37063((class_364)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.assets.author"), this.assets::setAuthor).setValue(this.assets.author).setPosition(x, 65).setSize(size, 20).build());
        this.method_37063((class_364)new SelectorBuilder((class_2561)class_2561.method_43471((String)"sailstatus.assets.base"), selectorButton -> {
            this.assets.setBaseAssets(Assets.getByName((String)selectorButton.getList()[selectorButton.getPosition()]).id);
            SailStatus.log(this.assets.getBaseAssets().name);
            this.assets.save();
            this.rebuildContentWidgets();
        }).setList(Assets.getAssetsNames(this.assets.name)).setValue(Assets.getPositionOnAssetsNames(this.assets.getBaseAssets() != null ? this.assets.getBaseAssets().name : ModConfig.defaultAssets.name, this.assets.name)).setPosition(x, 90).setWidth(size).build());
        this.descriptionBox = (TextBox)this.method_37063((class_364)new TextBuilder(Localization.toText((String)String.format(class_2561.method_43471((String)"sailstatus.assets.description").getString(), this.assets.name))).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, 115).setWidth(size).build());
        this.method_37063((class_364)new ButtonBuilder(class_5244.field_24339, s -> this.method_25419()).setPosition(x, this.field_22790 - 30).setSize(size - 50, 20).build());
        this.method_37063((class_364)new ButtonBuilder(Localization.getText((String)"sailstatus.assets.remove"), OnPress2 -> {
            this.isDeleted = true;
            if (this.isSelected) {
                SailStatus.userConfig.setString("USE_ASSETS", ModConfig.defaultAssets.id);
            }
            this.assets.delete();
            this.method_25419();
        }).setIcon(Icons.DONT).setPosition(x + size - 45, this.field_22790 - 30).setSize(20, 20).build());
        this.method_37063((class_364)new ButtonBuilder(Localization.getText((String)"sailstatus.assets.reload"), OnPress2 -> {
            this.assets.save();
            this.method_41843();
        }).setIcon(Icons.RESET).setPosition(x + size - 20, this.field_22790 - 30).setSize(20, 20).build());
    }

    public void initContent() {
        this.widgets = new ArrayList<class_339>();
        this.scroller = (ConfigureScrolWidget)this.method_37063((class_364)new ConfigureScrolWidget(this.field_22789 - 4, 0, 4, this.field_22790, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 5;
            for (class_339 widget : this.widgets) {
                if (widget.field_22764) {
                    widget.method_46419((int)((double)scroller.innerHeight - scroller.scrollAmount()));
                    widget.method_46421(200);
                    widget.method_25358(this.field_22789 - 210);
                    scroller.innerHeight += widget.method_25364() + 5;
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
        }));
        int x = 195;
        this.addWidget(new TextBuilder((class_2561)class_2561.method_43471((String)"sailstatus.assets.icons")).setPosition(x, 5).setSize(this.field_22789 - 200, 20).build());
        this.addWidget((class_339)new CategoryBox((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.title.menu")).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.logo"), newVal -> this.assets.setIcon("logo", (String)newVal)).setValue(this.assets.getIcon("logo")).build()));
        this.addWidget((class_339)new CategoryBox((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.title.time")).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.day"), newVal -> this.assets.setIcon("day", (String)newVal)).setValue(this.assets.getIcon("day")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.night"), newVal -> this.assets.setIcon("night", (String)newVal)).setValue(this.assets.getIcon("night")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.evening"), newVal -> this.assets.setIcon("evening", (String)newVal)).setValue(this.assets.getIcon("evening")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.morning"), newVal -> this.assets.setIcon("morning", (String)newVal)).setValue(this.assets.getIcon("morning")).build()));
        this.addWidget((class_339)new CategoryBox((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.title.worlds")).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.world"), newVal -> this.assets.setIcon("world", (String)newVal)).setValue(this.assets.getIcon("world")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.world_nether"), newVal -> this.assets.setIcon("world_nether", (String)newVal)).setValue(this.assets.getIcon("world_nether")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.world_the_end"), newVal -> this.assets.setIcon("world_the_end", (String)newVal)).setValue(this.assets.getIcon("world_the_end")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.world_moon"), newVal -> this.assets.setIcon("world_moon", (String)newVal)).setValue(this.assets.getIcon("world_moon")).build()));
        this.addWidget((class_339)new CategoryBox((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.title.modification")).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.voice"), newVal -> this.assets.setIcon("voice", (String)newVal)).setValue(this.assets.getIcon("voice")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.music"), newVal -> this.assets.setIcon("music", (String)newVal)).setValue(this.assets.getIcon("music")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.replaymod"), newVal -> this.assets.setIcon("replaymod", (String)newVal)).setValue(this.assets.getIcon("replaymod")).build()));
        this.addWidget((class_339)new CategoryBox((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.title.unknown")).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.unknown_world"), newVal -> this.assets.setIcon("unknown_world", (String)newVal)).setValue(this.assets.getIcon("unknown_world")).build()).addValue((class_339)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"sailstatus.config.assets.unknown"), newVal -> this.assets.setIcon("unknown", (String)newVal)).setValue(this.assets.getIcon("unknown")).build()));
    }

    protected void addWidget(class_339 widget) {
        this.widgets.add(widget);
        widget.method_25358(this.field_22789 - 210);
        widget.method_46421(200);
        if (widget instanceof CategoryBox) {
            this.widgets.addAll(((CategoryBox)widget).values);
            this.addWidgets(((CategoryBox)widget).values);
        }
        this.method_37063((class_364)widget);
    }

    protected void rebuildContentWidgets() {
        this.method_37066((class_364)this.scroller);
        this.scroller = null;
        for (class_339 widget : this.widgets) {
            this.method_37066((class_364)widget);
        }
        this.initContent();
    }

    protected void addWidgets(@NotNull List<class_339> widgets) {
        for (class_339 widget : widgets) {
            widget.method_25358(this.field_22789 - 210);
            widget.method_46421(200);
            this.method_37063((class_364)widget);
        }
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        super.method_25420(guiGraphics, i, j, f);
        guiGraphics.method_25294(0, 0, 190, this.field_22790, 0x37000000);
    }

    public void method_25393() {
        if (this.scroller != null) {
            this.scroller.onScroll.accept(this.scroller);
        }
        super.method_25393();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean scr = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (!scr && this.scroller != null) {
            scr = this.scroller.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return scr;
    }

    public void method_25419() {
        if (!this.isDeleted) {
            this.assets.save();
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }
}

