/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.sailstatus.config;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.info.Player;
import ru.kelcuprum.sailstatus.SailStatus;
import ru.kelcuprum.sailstatus.config.ModConfig;

public class Assets {
    public String id;
    public String name;
    public String base;
    public String author;
    protected JsonObject data;
    protected JsonObject icons;
    protected Assets defaultAssets;
    public File file;

    public Assets(File file) {
        this.file = file;
        Path assets = file.toPath();
        try {
            this.data = assets.toFile().exists() ? class_3518.method_15285((String)Files.readString(assets)) : new JsonObject();
        }
        catch (Exception e) {
            this.data = new JsonObject();
            SailStatus.log(e.getLocalizedMessage(), Level.ERROR);
        }
        this.load();
    }

    public Assets(JsonObject data) {
        this.data = data;
        this.load();
    }

    protected void load() {
        if (this.isValidObject(this.data)) {
            if (this.file != null) {
                this.data = new JsonObject();
                this.data.addProperty("id", this.file.getName().replace(".json", ""));
                this.data.addProperty("name", this.file.getName().replace(".json", ""));
                if (this.defaultAssets != null) {
                    this.data.addProperty("base", this.defaultAssets.id);
                }
                this.data.add("icons", new JsonObject());
            } else {
                throw new RuntimeException(String.format("The facility does not meet the criteria. JSON: %S", this.data.toString()));
            }
        }
        this.id = this.data.get("id").getAsString();
        this.name = this.data.get("name").getAsString();
        this.icons = this.data.getAsJsonObject("icons");
        if (!Assets.isJsonNull(this.data, "base") && this.data.getAsJsonPrimitive("base").isString()) {
            this.base = this.data.get("base").getAsString();
        }
        this.author = Assets.isJsonNull(this.data, "author") ? Player.getName() : this.data.get("author").getAsString();
    }

    private boolean isValidObject(JsonObject data) {
        boolean failed = false;
        if (data == null) {
            return true;
        }
        if (Assets.isJsonNull(data, "id")) {
            failed = true;
        } else if (Assets.isJsonNull(data, "name")) {
            failed = true;
        } else if (Assets.isJsonNull(data, "icons")) {
            failed = true;
        }
        return failed;
    }

    public Assets setBaseAssets(String id) {
        this.base = id;
        this.data.addProperty("base", id);
        return this;
    }

    public Assets getBaseAssets() {
        Assets baseAssets = null;
        if (this.base != null) {
            baseAssets = Assets.getByID(this.base);
        } else if (!Assets.isJsonNull(this.data, "base") && this.data.getAsJsonPrimitive("base").isString()) {
            this.base = this.data.get("base").getAsString();
            baseAssets = Assets.getByID(this.base);
        }
        if (baseAssets != null) {
            baseAssets.setDefaultAssets(ModConfig.defaultAssets);
        }
        return baseAssets;
    }

    public void setDefaultAssets(Assets defaultAssets) {
        this.defaultAssets = defaultAssets;
    }

    public String getIcon(String id) {
        String icon;
        String string = icon = this.defaultAssets == null ? "https://cdn.kelcuprum.ru/other/error.png" : this.defaultAssets.getIconFromData(id);
        if (!Assets.isJsonNull(this.icons, id) && this.icons.getAsJsonPrimitive(id).isString()) {
            icon = this.getIconFromData(id);
        } else if (this.getBaseAssets() != null && !this.getBaseAssets().name.equals(this.name)) {
            icon = this.getBaseAssets().getIcon(id);
        }
        return icon;
    }

    public String getIconFromData(String id) {
        String icon = "https://cdn.kelcuprum.ru/other/error.png";
        if (!Assets.isJsonNull(this.icons, id) && this.icons.getAsJsonPrimitive(id).isString()) {
            icon = this.icons.get(id).getAsString();
        }
        return icon;
    }

    public Assets setName(String name) {
        this.name = name;
        this.data.addProperty("name", name);
        return this;
    }

    public Assets setAuthor(String author) {
        this.author = author;
        this.data.addProperty("author", author);
        return this;
    }

    public Assets setIcon(String id, String url) {
        this.icons.addProperty(id, url);
        this.data.add("icons", this.icons);
        return this;
    }

    public Assets save() {
        if (this.file == null) {
            return this;
        }
        Path configFile = this.file.toPath();
        try {
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            Files.writeString(configFile, (CharSequence)this.data.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            SailStatus.log(e.getLocalizedMessage(), Level.ERROR);
        }
        Assets.registerAsset(this);
        return this;
    }

    public void delete() {
        if (this.file == null) {
            return;
        }
        SailStatus.assetsNames.remove(Assets.getPositionOnAssetsNames(this.name));
        SailStatus.assets.remove(this.id, this);
        this.file.delete();
        this.file = null;
    }

    public static boolean isJsonNull(JsonObject json, String id) {
        if (json == null) {
            return true;
        }
        if (!json.has(id)) {
            return true;
        }
        return json.get(id).isJsonNull();
    }

    public static void registerAsset(Assets assets) {
        if (assets.file == null) {
            SailStatus.modAssets.put(assets.id, assets);
            SailStatus.assets.put(assets.id, assets);
            SailStatus.assetsNames.add(assets.id);
            SailStatus.log(String.format("[Mod] Registration of %s by id %s", assets.name, assets.id));
        } else if (SailStatus.modAssets.get(assets.id) == null) {
            if (SailStatus.assets.get(assets.id) == null) {
                SailStatus.assetsNames.add(assets.id);
            }
            SailStatus.assets.put(assets.id, assets);
            SailStatus.log(String.format("[File] Registration of %s by id %s", assets.name, assets.id));
        } else {
            SailStatus.log(String.format("[File] Registration of %s by id %s failed, conflict of internal assets", assets.name, assets.id));
        }
    }

    public static String[] getAssetsNames() {
        String[] list = new String[SailStatus.assetsNames.size()];
        int i = 0;
        for (String id : SailStatus.assetsNames) {
            list[i] = SailStatus.assets.getOrDefault((Object)id, (Assets)ModConfig.defaultAssets).name;
            ++i;
        }
        return list;
    }

    public static String[] getAssetsNames(String name) {
        String[] list = new String[SailStatus.assetsNames.size() - 1];
        int i = 0;
        for (String id : SailStatus.assetsNames) {
            if (SailStatus.assets.getOrDefault((Object)id, (Assets)ModConfig.defaultAssets).name.equals(name)) continue;
            list[i] = SailStatus.assets.getOrDefault((Object)id, (Assets)ModConfig.defaultAssets).name;
            ++i;
        }
        return list;
    }

    public static int getPositionOnAssetsNames(String name) {
        int i = 0;
        for (String id : Assets.getAssetsNames()) {
            if (id.equals(name)) break;
            ++i;
        }
        return i;
    }

    public static int getPositionOnAssetsNames(String name, String withoutName) {
        int i = 0;
        for (String id : Assets.getAssetsNames(withoutName)) {
            if (id.equals(name)) break;
            ++i;
        }
        return i;
    }

    public static Assets getByName(String name) {
        Assets assets = ModConfig.defaultAssets;
        for (String id : SailStatus.assetsNames) {
            Assets assetsById = Assets.getByID(id);
            if (!Objects.equals(assetsById.name, name)) continue;
            assets = assetsById;
        }
        assets.setDefaultAssets(ModConfig.defaultAssets);
        return assets;
    }

    public static Assets getByID(String id) {
        Assets assets = SailStatus.assets.getOrDefault(id, ModConfig.defaultAssets);
        assets.setDefaultAssets(ModConfig.defaultAssets);
        return assets;
    }

    public static Assets getSelected() {
        String id = SailStatus.userConfig.getString("USE_ASSETS", ModConfig.defaultAssets.id);
        return Assets.getByID(id);
    }

    public static void loadFiles() {
        File assets = AlinLib.MINECRAFT.field_1697.toPath().resolve("config/SailStatus/assets").toFile();
        if (assets.exists() && assets.isDirectory()) {
            for (File assetsFile : Objects.requireNonNull(assets.listFiles())) {
                if (!assetsFile.isFile() || !assetsFile.getName().endsWith(".json")) continue;
                try {
                    Assets assetsObject = new Assets(assetsFile);
                    assetsObject.setDefaultAssets(ModConfig.defaultAssets);
                    Assets.registerAsset(assetsObject);
                }
                catch (Exception e) {
                    SailStatus.log(e.getLocalizedMessage(), Level.ERROR);
                }
            }
        }
    }
}

